/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.bootstrap.bcp;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.EndpointDistributor;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.parser.StatusPageParser;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.verifier.StatusPageSignatureVerifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointUpdater {
    public static final String PROP_BCP_STATUS_ENDPOINT = "be.ehealth.technicalconnector.bcp.status.endpoint";
    public static final String PROP_BCP_CACHE_DIR = "bcp.local.cache.dir";
    private static final Logger LOG = LoggerFactory.getLogger(EndpointUpdater.class);
    private static ConfigValidator config = ConfigFactory.getConfigValidator();
    private static String loadedSha2;
    private static String loadedSha2Location;
    private static String loadedXmlLocation;

    private EndpointUpdater() {
        throw new UnsupportedOperationException();
    }

    public static boolean update() throws TechnicalConnectorException {
        String endpoint = EndpointUpdater.determineEndpoint();
        String onlineSha2 = ConnectorIOUtils.getResourceAsString((String)(endpoint + ".sha2"));
        if (!onlineSha2.equals(loadedSha2)) {
            String content = ConnectorIOUtils.getResourceAsString((String)(endpoint + ".xml"));
            EndpointUpdater.update(content);
            EndpointUpdater.write(content, loadedXmlLocation);
            EndpointUpdater.write(onlineSha2, loadedSha2Location);
            loadedSha2 = onlineSha2;
            return true;
        }
        LOG.debug("No change detected");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(String content, String location) {
        Validate.notEmpty((CharSequence)location);
        FileOutputStream fos = null;
        try {
            File output = new File(location);
            if (!output.exists() && !output.createNewFile()) {
                throw new IOException("Unable to create new file. [" + location + "]");
            }
            fos = new FileOutputStream(output);
            IOUtils.write((byte[])content.getBytes(Charset.UTF_8.getName()), (OutputStream)fos);
        }
        catch (IOException e) {
            try {
                LOG.error("Unable to write content to file [" + location + "]", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(fos);
                throw throwable;
            }
            ConnectorIOUtils.closeQuietly((Object)fos);
        }
        ConnectorIOUtils.closeQuietly((Object)fos);
    }

    private static boolean update(String xml) throws TechnicalConnectorException {
        if (StatusPageSignatureVerifier.isValid(xml)) {
            EndpointDistributor.getInstance().update(StatusPageParser.parse(xml));
            return true;
        }
        LOG.error("Unable to update endpoint. For more information see logs.");
        return false;
    }

    private static String determineEndpoint() {
        String env = config.getProperty("environment", "prd");
        String endpoint = config.getProperty(PROP_BCP_STATUS_ENDPOINT);
        if (StringUtils.isNotBlank((String)endpoint)) {
            return endpoint;
        }
        if ("prd".equals(env)) {
            return "https://servicelist.ehealth.fgov.be/servicelist";
        }
        if ("acc".equals(env)) {
            return "https://servicelist-acpt.ehealth.fgov.be/servicelist";
        }
        if ("int".equals(env)) {
            return "https://bcp-int.ehealth.fgov.be/current_status";
        }
        throw new IllegalArgumentException("Unsupported Environment [" + env + "]");
    }

    public static void reset() {
        EndpointUpdater.delete(loadedSha2Location);
        EndpointUpdater.delete(loadedXmlLocation);
        loadedSha2 = null;
        EndpointDistributor.getInstance().reset();
    }

    private static void delete(String location) {
        File file = new File(location);
        if (file.delete()) {
            LOG.debug("File [{}] deleted.", (Object)file.getName());
        } else {
            LOG.debug("Unable to delete [{}].", (Object)file.getName());
        }
    }

    static {
        try {
            if (config.hasProperty(PROP_BCP_CACHE_DIR)) {
                String basePath = config.getProperty(PROP_BCP_CACHE_DIR);
                loadedSha2Location = basePath + EndpointUpdater.class.getCanonicalName() + ".sha2";
                loadedXmlLocation = basePath + EndpointUpdater.class.getCanonicalName() + ".xml";
            } else {
                loadedSha2Location = ConnectorIOUtils.getTempFileLocation((String)(EndpointUpdater.class.getCanonicalName() + ".sha2"));
                loadedXmlLocation = ConnectorIOUtils.getTempFileLocation((String)(EndpointUpdater.class.getCanonicalName() + ".xml"));
            }
            if (EndpointUpdater.update(ConnectorIOUtils.getResourceAsString((String)loadedXmlLocation))) {
                loadedSha2 = ConnectorIOUtils.getResourceAsString((String)loadedSha2Location);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to load endpoints", (Throwable)e);
        }
    }
}

