/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModuleSSLVerifier
implements ConfigurationModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleSSLVerifier.class);
    private SSLSocketFactory oldSSLSocketFactory;

    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        LOG.debug("Initializing ConfigurationModule {}", (Object)this.getClass().getName());
        LOG.warn("Activating bypass: SSL verifcation. DO NOT USE THIS IN PRODUCTION.");
        TrustManager[] trustAllCerts = new TrustManager[]{new ConnectorTrustManager()};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            this.oldSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
    }

    @Override
    public void unload() throws TechnicalConnectorException {
        LOG.debug("Unloading ConfigurationModule {}", (Object)this.getClass().getName());
        HttpsURLConnection.setDefaultSSLSocketFactory(this.oldSSLSocketFactory);
    }

    private static class ConnectorTrustManager
    implements X509TrustManager {
        private ConnectorTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            LOG.warn("SSL verifcation disabled! DO NOT USE THIS IN PRODUCTION.");
            LOG.debug("getAcceptedIssuers() : empty list");
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
            LOG.debug("checkClientTrusted() : authType={}", (Object)authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
            LOG.debug("checkServerTrusted() : authType={}", (Object)authType);
            for (int i = 0; i < certs.length; ++i) {
                LOG.debug("Server Certificate to be checked {} : {} with issuer: {}", new Object[]{i, certs[i].getSubjectX500Principal().getName("RFC1779"), certs[i].getIssuerX500Principal().getName("RFC1779")});
            }
        }
    }
}

