﻿/*
 * Copyright (c) eHealth
 */
using be.cin.mycarenet.esb.common.v2;
using be.cin.nip.async.generic;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.business.mycarenetdomaincommons.mapper;
using be.ehealth.business.mycarenetdomaincommons.util;
using be.ehealth.businessconnector.genericasync.builders;
using be.ehealth.businessconnector.genericasync.exception;
using be.ehealth.businessconnector.genericasync.mappers;
using be.ehealth.businessconnector.genericasync.session;
using be.ehealth.businessconnector.genericasync.domain;
using be.ehealth.businessconnector.genericasync.encrypt;
using be.ehealth.businessconnector.testcommons.utils;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.handler.domain;
using be.ehealth.technicalconnector.utils;
using org.apache.commons.lang;
using be.ehealth.business.mycarenetcommons.builders.util;
using be.ehealth.business.mycarenetdomaincommons.domain.async;
using be.ehealth.technicalconnector.idgenerator;
using org.slf4j;
using System;
using ikvm.extensions;
using java.lang;
using java.io;
using java.net;
using java.util;
using NUnit.Framework;

namespace be.ehealth.businessconnector.genericasync.test.helper
{


public class PostTestHelper {

		private static Logger LOG = LoggerFactory.getLogger(typeof(PostTestHelper));
		
		private static string DEFAULT_PLATFORM_NAME = "mycarenet";


        private string projectName;
    
        private string oa;
        
        private bool test;
        
        private bool withXades;
        
        private string platformName;

    	private bool encrypted;
    
        private PostTestHelper(Builder builder) {
            projectName = builder.projectName;
            oa = builder.oa;
            test = builder.test;
            withXades = builder.withXades;
            platformName = builder.platformName == null ? DEFAULT_PLATFORM_NAME : builder.platformName;
            encrypted = builder.encrypted;
        }
    
        public static Builder builder() {
            return new Builder();
        }
    
    
        public void validateResponse(PostResponse responsePost) {
            ConnectorXmlUtils.dump(responsePost);
            ResponseObjectBuilder responseBuilder = BuilderFactory.getResponseObjectBuilder();
            responseBuilder.handlePostResponse(responsePost);
        }
    
        public PostResponse post(string serviceName, Post post) {
            GenAsyncService service = GenAsyncSessionServiceFactory.getGenAsyncService(serviceName);
            WsAddressingHeader header = WsAddressingUtil.createHeader(oa, GenericAsyncConstants.POST_SOAP_ACTION);
            return service.postRequest(post, header);
        }
        
         public Post buildPostRequest(byte[] contentBytes, string messageName) {
            BlobBuilder blobBuilder = BlobBuilderFactory.getBlobBuilder(projectName);
            Blob blob = blobBuilder.build(contentBytes);
            blob.setMessageName(messageName);
            string commonInputReference = IdGeneratorFactory.getIdGenerator().generateId();
            byte[] xades = null;
            if (withXades) {
                xades = BlobUtil.generateXades(blob, projectName, platformName);
            }
            
            PostContent postContent = PostContent.Builder()
                    .blob(blob)
                    .commonInputReference(commonInputReference)
                    .isTest(test)
                    .messageName(messageName)
                    .xades(xades)
                    .build();
            
            return buildPostRequest(contentBytes, messageName, platformName);
         }
    
        public Post buildPostRequest(byte[] contentBytes, string messageName, string platformName) {
            if(encrypted) {
                contentBytes = BusinessContentEncryptor.encrypt(projectName, contentBytes, messageName, platformName);
            }
            BlobBuilder blobBuilder = BlobBuilderFactory.getBlobBuilder(projectName);
            Blob blob = blobBuilder.build(contentBytes);
            blob.setMessageName(messageName);
            string commonInputReference = IdGeneratorFactory.getIdGenerator().generateId();
            byte[] xades = null;
            if (withXades && !encrypted) {
                xades = BlobUtil.generateXades(blob, projectName, platformName);
            }
            
            PostContent postContent = PostContent.Builder()
                    .blob(blob)
                    .commonInputReference(commonInputReference)
                    .isTest(test)
                    .messageName(messageName)
                    .xades(xades)
                    .build();
            
            return BuilderFactory.getRequestObjectBuilder(projectName).buildPostRequest(projectName, postContent);
        }
    
        public class Builder {
            public string projectName;
            public string oa;
            public bool test = true;
            public bool withXades;
            public string platformName = DEFAULT_PLATFORM_NAME;
        	public bool encrypted;
    
            public Builder() {
            }
    
            public Builder withProjectName(string projectName) {
                this.projectName = projectName;
                return this;
            }
    
            public Builder withOa(string oa) {
                this.oa = oa;
                return this;
            }
    
            public Builder isTest(bool test) {
                this.test = test;
                return this;
            }
    
            public Builder hasXades(bool withXades) {
                this.withXades = withXades;
                return this;
            }
        	
        	public Builder withPlatformName(string platformName) {
            	this.platformName = platformName;
            	return this;
        	}

        	public Builder isEncrypted(bool encrypted) {
            	this.encrypted = encrypted;
            	return this;
        	}	
    
            public PostTestHelper build() {
                return new PostTestHelper(this);
            }
        }   
    }
}
