﻿/*
 * Copyright (c) eHealth
 */
using System;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using org.joda.time;
using org.joda.time.format;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.standards.kmehr.cd.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;
using be.fgov.ehealth.standards.kmehr.dt.v1;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.business.common.domain;
using be.ehealth.technicalconnector.adapter;
using be.cin.encrypted;
using be.fgov.ehealth.messageservices.core.v1;
using be.ehealth.businessconnector.mycarenet.attestv2.domain;
using be.fgov.ehealth.mycarenet.attest.protocol.v2;
using be.ehealth.businessconnector.attestv2.helper;

namespace be.ehealth.businessconnector.attestv2.session
{
	/**
	 * eAttest Integration Test. The scenarios numbering matches one specified by mycarenet.
	 *
	 * @author EHP
	 */
	[TestFixture]
	public class CancelAttestDentistIntegrationTest
	{
    
    
    private AttestIntegrationTestHelper helper = new AttestIntegrationTestHelper();

    [SetUp]
    public static  void setupsession() {
       	SessionInitializer.init(".\\be.ehealth.businessconnector.attestv2.dentist.test.properties", SupportedLanguages.NET.getAbbreviation());
    }
    
    [TearDown]
    public static void teardownSession()  {
    	Session.getInstance().unloadSession();
    }

    [Test]
    public void cancelAttestationOA100DENT8a()  {
        InputReference inputReference = new InputReference();
        String scenarioName = "DENT8a";

        CancelAttestationResponse response = helper.cancelAttestation(new InputReference(),scenarioName, "73052005540", "DENT","100-1-190226-9851229-88");

        assertCancelResult(inputReference, scenarioName, "100", "DENT", response);
    }

   [Test]
    public void cancelAttestationOA500DENT8a()  {
        InputReference inputReference = new InputReference();
        String scenarioName = "DENT8a";

        CancelAttestationResponse response = helper.cancelAttestation(new InputReference(),scenarioName, "62110906574", "DENT","500-1-190110-4567890-16");

        assertCancelResult(inputReference, scenarioName, "500", "DENT", response);
    }

    [Test]
    public void cancelAttestationOA100DENT8b()  {
        InputReference inputReference = new InputReference();
        String scenarioName = "DENT8b";

        CancelAttestationResponse response = helper.cancelAttestation(new InputReference(),scenarioName, "73052005540", "DENT","100-1-190226-9851229-88");

        assertCancelResult(inputReference, scenarioName, "100", "DENT", response);
    }

    [Test]
    public void cancelAttestationOA500DENT8b()  {
        InputReference inputReference = new InputReference();
        String scenarioName = "DENT8b";

        CancelAttestationResponse response = helper.cancelAttestation(new InputReference(),scenarioName, "62110906574", "DENT","500-1-190110-4567890-16");

        assertCancelResult(inputReference, scenarioName, "500", "DENT", response);
    }

    [Test]
    public void cancelAttestationOA100DENT8c()  {
        InputReference inputReference = new InputReference();
        String scenarioName = "DENT8c";

        CancelAttestationResponse response = helper.cancelAttestation(new InputReference(),scenarioName, "73052005540", "DENT","100-1-190226-9851229-88");

        assertCancelResult(inputReference, scenarioName, "100", "DENT", response);
    }

    [Test]
    public void cancelAttestationOA500DENT8c()  {
        InputReference inputReference = new InputReference();
        String scenarioName = "DENT8c";

        CancelAttestationResponse response = helper.cancelAttestation(new InputReference(),scenarioName, "62110906574", "DENT","500-1-190110-4567890-16");

        assertCancelResult(inputReference, scenarioName, "500", "DENT", response);
    }

    [Test]
    public void cancelAttestationOA100DENT9()  {
      InputReference inputReference = new InputReference();
      String ssin = "73052005540";
      SendAttestationResponse sendResponse = helper.sendAttestation(inputReference,"DENT4", ssin, "DENT");
      String ack = helper.getInvoiceNumber(sendResponse);
      String scenarioName = "DENT9";

      CancelAttestationResponse response = helper.cancelAttestation(new InputReference(),scenarioName, "73052005540", "DENT",ack);

      assertCancelResult(inputReference, scenarioName, "100", "DENT", response);
    }

    [Test]
    public void cancelAttestationOA500DENT9()  {
      InputReference inputReference = new InputReference();
      String ssin = "62110906574";
      SendAttestationResponse sendResponse = helper.sendAttestation(inputReference,"DENT9Send", ssin, "DENT");
      String ack = helper.getInvoiceNumber(sendResponse);
      String scenarioName = "DENT9";

      CancelAttestationResponse response = helper.cancelAttestation(new InputReference(),scenarioName, ssin, "DENT",ack);

      assertCancelResult(inputReference, scenarioName, "500", "DENT", response);
    }

    private void assertCancelResult(InputReference inputReference, String scenarioName, String oa, String profession, CancelAttestationResponse response)  {
        SignedBuilderResponse builderResponse = helper.getBuildCancelAttestResponse(response);
        Assert.AreEqual(0, builderResponse.getSignatureVerificationResult().getErrors().size(), "SignatureVerificationResult should contain no error");
        XmlAsserter.assertSimilar(ConnectorXmlUtils.toObject(builderResponse.getSignedData(), typeof(CancelAttestationResponse)), response);
        String expectedResponse = helper.buildExpectedCancelAttestResponse(builderResponse, inputReference.getInputReference(),scenarioName, oa, profession);
        XmlAsserter.assertSimilar(expectedResponse, ConnectorXmlUtils.toString(builderResponse.getSendTransactionResponse()));
    }
    
	}
}
