/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.bootstrap.bcp;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.ws.ServiceFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.EndpointUpdateRule;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.HttpServerStubRule;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

/**
 * @author EH053
 */
public class GenericRequestCachingTest {


    @Rule
    public EndpointUpdateRule rule = new EndpointUpdateRule("/tsl-samples/local/servicelistv2-local");

    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Rule
    public HttpServerStubRule server6666 = new HttpServerStubRule(6666);

    @Test
    public void walk() throws Exception {
        server6666.add("/EtkDepot/v1", ConnectorIOUtils.getResourceAsString("/samples/etkdepot-response.xml"));

        GenericRequest req = new GenericRequest();
        req.setPayload(ConnectorIOUtils.getResourceAsString("/samples/etkdepot-request.xml"));
        req.setEndpoint("http://localhost:6666/EtkDepot/v1");
        String request = ServiceFactory.getGenericWsSender().send(req).asString();

        Assert.assertTrue(StringUtils.contains( request,"425ad6d2-d627-4749-add2-62599834b118"));

        server6666.shutdown();

        req = new GenericRequest();
        req.setPayload(ConnectorIOUtils.getResourceAsString("/samples/etkdepot-request.xml"));
        req.setEndpoint("http://localhost:6666/EtkDepot/v1");
        String request2 = ServiceFactory.getGenericWsSender().send(req).asString();

        Assert.assertTrue(StringUtils.contains( request2,"425ad6d2-d627-4749-add2-62599834b118"));

    }

    @Test
    public void invokeWithCache() throws Exception {
        GenericRequest req = new GenericRequest();
        server6666.shutdown();

        req.setPayload(ConnectorIOUtils.getResourceAsString("/samples/etkdepot-request.xml"));
        req.setEndpoint("http://localhost:6666/EtkDepot/v1");
        String request2 = ServiceFactory.getGenericWsSender().send(req).asString();

        Assert.assertTrue(StringUtils.contains( request2,"425ad6d2-d627-4749-add2-62599834b118"));

    }


}
