﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.consultrn.protocol.v2;
using ikvm.extensions;
using java.lang;
using java.util;
using NUnit.Framework;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.consultrn._1_0.protocol;
using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.ehealth.businessconnector.testcommons.utils;
using be.ehealth.businessconnector.consultrn.exception.identifyperson;
using be.ehealth.businessconnector.consultrn.exception.phoneticsearch;
using be.ehealth.businessconnector.consultrn.exception.manageperson;
using be.ehealth.technicalconnector.idgenerator;
using javax.xml.ws.soap;
using be.fgov.ehealth.consultrn._1_0.core;
using be.fgov.ehealth.commons._1_0.core;
using be.fgov.ehealth.consultrn.commons.core.v3;
using org.apache.commons.io;
using org.apache.commons.lang;

namespace be.ehealth.businessconnector.consultrn.session
{
	[TestFixture]
	public class ConsultrnIntegrationTest
	{
		
		private static string SSIN = "85040309180";
		
		private static org.joda.time.DateTime BEGIN_DATE = new org.joda.time.DateTime();
		
		private static org.joda.time.DateTime END_DATE = new org.joda.time.DateTime().plusDays(1);
		
		
		
		[SetUpAttribute]
		public static void setupsession() {
			SessionInitializer.init(".\\be.ehealth.businessconnector.consultrn.test.properties",true, SupportedLanguages.NET.getAbbreviation());
		}

		[TearDownAttribute]
		public static void teardownSession() {
			Session.getInstance().unloadSession();
		}
		
		[Test]
		public void searchBySSIN_Search() {
			SearchBySSINRequest searchBySSINRequest = createSearchBySsinRequest("78080904422", "85040309180", "4",
			                                                                    BEGIN_DATE, END_DATE);

			SearchBySSINReply searchBySSINReply = ConsultrnSessionServiceFactory.getConsultrnSession()
				.search(searchBySSINRequest);
			
			string responseFileContent = ConnectorIOUtils.getResourceAsString(".\\examples\\identifyPerson\\response\\searchBySSINReply-search.xml");
			string responsestringObject = ConnectorXmlUtils.toString(searchBySSINReply);
			XmlAsserter.assertSimilar(responseFileContent, responsestringObject);
		}
		
		[Test]
		public void searchBySSIN_SearchWrongIdentifier() {
			SearchBySSINRequest searchBySSINRequest = createSearchBySsinRequest("10410111363", "56082053893", "10",
			                                                                    BEGIN_DATE, END_DATE);
			try {
				ConsultrnSessionServiceFactory.getConsultrnSession().search(searchBySSINRequest);
				Assert.Fail("should throw ConsultrnIdentifyPersonException");
			} catch (ConsultrnIdentifyPersonException e) {
				Assert.NotNull(e.getSearchBySSINReply());
				Assert.AreEqual("60", e.getSearchBySSINReply().getStatus().getCode());
				Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ns2:Status xmlns:ns2=\"urn:be:fgov:ehealth:commons:1_0:core\"><Code>60</Code><Message Lang=\"EN\">Business Problem : invalid request</Message><Message Lang=\"EN\">SSIN malformed</Message></ns2:Status>", e.getMessage());
			}
		}
		

		
		[Test]
		public void searchBySSIN_SearchWrongQuality() {
			SearchBySSINRequest searchBySSINRequest = createSearchBySsinRequest("10410111363", "56082053894", "10",
			                                                                    BEGIN_DATE, END_DATE);
			try {
				ConsultrnSessionServiceFactory.getConsultrnSession().search(searchBySSINRequest);
				Assert.Fail("Should throw ConsultrnIdentifyPersonException");
			} catch (ConsultrnIdentifyPersonException e) {
				Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ns2:Status xmlns:ns2=\"urn:be:fgov:ehealth:commons:1_0:core\"><Code>86</Code><Message Lang=\"EN\">Business Error : wrong quality</Message><Message Lang=\"EN\">Wrong quality (IdentifyPerson)</Message></ns2:Status>", e.getMessage());
			}
		}
		
		[Test]
		public void searchBySSIN_SearchNoPeriodSoapFaultException() {
			SearchBySSINRequest searchBySSINRequest = createSearchBySsinRequest("10410111363", "56082053894", "10");

			try {
				ConsultrnSessionServiceFactory.getConsultrnSession().search(searchBySSINRequest);
				Assert.Fail("Should throw unsupported error");
			} catch (SOAPFaultException e) {
				Assert.IsTrue(e.getMessage().Contains("XML could not be validated against XSD."));
			}
		}
		
		[Test]
		public void searchBySSIN_SearchSameBeginDate() {
			SearchBySSINRequest searchBySSINRequest = createSearchBySsinRequest("78080904422", SSIN, "4", BEGIN_DATE,
			                                                                    BEGIN_DATE);
			
			SearchBySSINReply searchBySSINReply = ConsultrnSessionServiceFactory.getConsultrnSession()
				.search(searchBySSINRequest);
			string expectedResponse = ConnectorIOUtils.getResourceAsString(".\\examples\\identifyPerson\\response\\searchBySSINReply-searchWrongBeginDate.xml");
			XmlAsserter.assertSimilar(expectedResponse, ConnectorXmlUtils.toString(searchBySSINReply));
		}
		
		[Test]
		public void searchBySSIN_SearchWrongEndDateBusinessError() {
			SearchBySSINRequest searchBySSINRequest = createSearchBySsinRequest("78080904422", SSIN, "4", END_DATE,
			                                                                    BEGIN_DATE);
			try {
				ConsultrnSessionServiceFactory.getConsultrnSession().search(searchBySSINRequest);
				Assert.Fail("Should throw unsupported error");
			} catch (ConsultrnIdentifyPersonException e) {
				Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ns2:Status xmlns:ns2=\"urn:be:fgov:ehealth:commons:1_0:core\"><Code>85</Code><Message Lang=\"EN\">Business Error : invalid dates</Message><Message Lang=\"EN\">Period is invalid</Message></ns2:Status>", e.getMessage());
			}
		}
		
		[Test]
		public void searchPhonetic_Search() {
			SearchPhoneticRequest searchPhoneticRequest = createSearchPhoneticRequest("10410111363", "Dupont", "Benoit",
			                                                                          "1984-06-11");
			
			SearchPhoneticReply searchPhoneticReply = ConsultrnSessionServiceFactory.getConsultrnSession()
				.search(searchPhoneticRequest);
			
			string expectedResponse = ConnectorIOUtils.getResourceAsString(".\\examples\\phoneticSearch\\searchPhoneticReply-search.xml");

			XmlAsserter.assertSimilar(expectedResponse, ConnectorXmlUtils.toString(searchPhoneticReply));
		}
		
		[Test]
		public void searchPhonetic_SearchWrongBirthdateSoapFaultException() {
			SearchPhoneticRequest searchPhoneticRequest = createSearchPhoneticRequest("10410111363", "Dupont", "Benoit",
			                                                                          "1984-06-112");
			try {
				ConsultrnSessionServiceFactory.getConsultrnSession().search(searchPhoneticRequest);
				Assert.Fail("Should throw unsupported error");
			} catch (SOAPFaultException e) {
				Assert.IsTrue(e.getMessage().Contains("XML could not be validated against XSD."));
			}
		}
		
		[Test]
		public void searchPhonetic_SearchBusinessError() {
			SearchPhoneticRequest searchPhoneticRequest = createSearchPhoneticRequest("10410111363", "Dupont", "Benoit",
			                                                                          "1984-00-00");
			try {
				ConsultrnSessionServiceFactory.getConsultrnSession().search(searchPhoneticRequest);
				Assert.Fail("Should throw unsupported error");
			} catch (ConsultrnPhoneticSearchException e) {
				Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ns2:Status xmlns:ns2=\"urn:be:fgov:ehealth:commons:1_0:core\"><Code>63</Code><Message Lang=\"EN\">Business Problem : invalid request</Message><Message Lang=\"EN\">Invalid phonetic search criteria</Message></ns2:Status>", e.getMessage());
			}
		}
			
		[Test]
		public void registerPerson_MidBirth() {
			RegisterPersonResponse response = registerPerson(".\\examples\\managePerson\\request\\registerPerson-MIDBirth.xml");
			XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-MIDBirth.xml"), ConnectorXmlUtils.toString(response));
		}

		[Test]
		public void registerPerson_MidBelgianAddress() {
			RegisterPersonResponse response = registerPerson(".\\examples\\managePerson\\request\\registerPerson-MIDBelgianAddress.xml");
			XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-MIDBelgianAddress.xml"), ConnectorXmlUtils.toString(response));
		}

		[Test]
		public void registerPerson_MidForeignAddress() {
			RegisterPersonResponse response = registerPerson(".\\examples\\managePerson\\request\\registerPerson-MIDForeignAddress.xml");
			XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-MIDForeignAddress.xml"), ConnectorXmlUtils.toString(response));
		}

		[Test]
		public void registerPerson_FullInformation() {
			RegisterPersonResponse response = registerPerson(".\\examples\\managePerson\\request\\registerPerson-FullInformation.xml");
			XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-FullInformation.xml"), ConnectorXmlUtils.toString(response));
		}

		[Test]
		public void registerPerson_ExistingPersonEHP() {
			try {
				registerPerson(".\\examples\\managePerson\\request\\registerPerson-ExistingPerson-EHP.xml");
				Assert.Fail("This test should send an exception");
			} catch (ConsultrnRegisterExistingPersonException e) {
			    Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Status xmlns=\"urn:be:fgov:ehealth:commons:core:v2\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:Requester\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:RequestDenied\"/></StatusCode><StatusMessage>Registration of the BIS person cannot proceed. One or more persons with a phonetic match to the given criteria already exist.</StatusMessage></Status>", e.getMessage());
				XmlAsserter.assertSimilar(
					ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-ExistingPerson-EHP.xml"),
					ConnectorXmlUtils.toString(e.getRegisterPersonResponse()));
			}
		}

		[Test]
		public void registerPerson_ExistingPersonFilteredData() {
			try {
				registerPerson(".\\examples\\managePerson\\request\\registerPerson-ExistingPerson-FilteredData.xml");
				Assert.Fail("This test should send an exception");
			} catch (ConsultrnRegisterExistingPersonException e) {
                Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Status xmlns=\"urn:be:fgov:ehealth:commons:core:v2\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:Requester\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:RequestDenied\"/></StatusCode><StatusMessage>Registration of the BIS person cannot proceed. One or more persons with a phonetic match to the given criteria already exist.</StatusMessage></Status>", e.getMessage());			
				XmlAsserter.assertSimilar(
					ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-ExistingPerson-FilteredData.xml"),
					ConnectorXmlUtils.toString(e.getRegisterPersonResponse()));
			}
		}

		[Test]
		public void registerPerson_ExistingPersonHospital() {
			try {
				registerPerson(".\\examples\\managePerson\\request\\registerPerson-ExistingPerson-HOSPITAL.xml");
				Assert.Fail("This test should send an exception");
			} catch (ConsultrnRegisterExistingPersonException e) {
                Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Status xmlns=\"urn:be:fgov:ehealth:commons:core:v2\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:Requester\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:RequestDenied\"/></StatusCode><StatusMessage>Registration of the BIS person cannot proceed. One or more persons with a phonetic match to the given criteria already exist.</StatusMessage></Status>", e.getMessage());									
				XmlAsserter.assertSimilar(
					ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-ExistingPerson-HOSPITAL.xml"),
					ConnectorXmlUtils.toString(e.getRegisterPersonResponse()));
			}
		}

		[Test]
		public void registerPerson_ExistingPersonLabo() {
			try {
				registerPerson(".\\examples\\managePerson\\request\\registerPerson-ExistingPerson-LABO.xml");
				Assert.Fail("This test should send an exception");
			} catch (ConsultrnRegisterExistingPersonException e) {
                Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Status xmlns=\"urn:be:fgov:ehealth:commons:core:v2\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:Requester\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:RequestDenied\"/></StatusCode><StatusMessage>Registration of the BIS person cannot proceed. One or more persons with a phonetic match to the given criteria already exist.</StatusMessage></Status>", e.getMessage());									
				XmlAsserter.assertSimilar(
					ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-ExistingPerson-LABO.xml"),
					ConnectorXmlUtils.toString(e.getRegisterPersonResponse()));
			}
		}

		[Test]
		public void registerPerson_ExistingPerson() {
			try {
				registerPerson(".\\examples\\managePerson\\request\\registerPerson-ExistingPerson.xml");
				Assert.Fail("This test should send an exception");
			} catch (ConsultrnRegisterExistingPersonException e) {
		        Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Status xmlns=\"urn:be:fgov:ehealth:commons:core:v2\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:Requester\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:RequestDenied\"/></StatusCode><StatusMessage>Registration of the BIS person cannot proceed. One or more persons with a phonetic match to the given criteria already exist.</StatusMessage></Status>", e.getMessage());														
				XmlAsserter.assertSimilar(
                    ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-ExistingPerson.xml"),
                    ConnectorXmlUtils.toString(e.getRegisterPersonResponse()));
			}
		}

		[Test]
		public void registerPerson_SeveralExistingPersons() {
			try {
				registerPerson(".\\examples\\managePerson\\request\\registerPerson-SeveralExistingPerson.xml");
				Assert.Fail("This test should send an exception");
			} catch (ConsultrnRegisterExistingPersonException e) {
                Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Status xmlns=\"urn:be:fgov:ehealth:commons:core:v2\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:Requester\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:RequestDenied\"/></StatusCode><StatusMessage>Registration of the BIS person cannot proceed. One or more persons with a phonetic match to the given criteria already exist.</StatusMessage></Status>", e.getMessage());														
				XmlAsserter.assertSimilar(
					ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-SeveralExistingPerson.xml"),
					ConnectorXmlUtils.toString(e.getRegisterPersonResponse()));
			}
		}
		
		[Test]
		public void registerPerson_ErrorInvalidFirstname() {
			try {
				registerPerson(".\\examples\\managePerson\\request\\registerPerson-InvalidFirstname.xml");
				Assert.Fail("This test should send an exception");
			} catch (ConsultrnRegisterPersonException e) {
                Assert.AreEqual("Error while executing web service call: <?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Status xmlns=\"urn:be:fgov:ehealth:commons:core:v2\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:Requester\"><StatusCode Value=\"urn:be:fgov:ehealth:2.0:status:InvalidInput\"/></StatusCode><StatusMessage>XSD compliance failure: string length (49) is greater than maxLength facet (48) for GivenNameType in namespace http://kszbcss.fgov.be/types/legaldata/v3</StatusMessage></Status>", e.getMessage());														
				XmlAsserter.assertSimilar(
					ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-InvalidFirstname.xml"),
					ConnectorXmlUtils.toString(e.getRegisterPersonResponse()));
			}
		}
		
		[Test]
        public void registerPerson_ErrorNoValidMID() {
            try {
                registerPerson(".\\examples\\managePerson\\request\\registerPerson-InvalidInput-NoValidMID.xml");
                Assert.Fail("This test should send an exception");
            } catch (ConsultrnRegisterPersonException e) {
				Assert.AreEqual("800036", ((BusinessAnomalyType) e.getBusinessAnomalies().getBusinessAnomalies().get(0)).getCode());
                XmlAsserter.assertSimilar(
                        ConnectorIOUtils.getResourceAsString(".\\examples\\managePerson\\response\\registerPerson-InvalidInput-NoValidMID.xml"),
                        ConnectorXmlUtils.toString(e.getRegisterPersonResponse()));
            }
        }

		private RegisterPersonResponse registerPerson(string testRequestFileLocation) {
            Map velocityContext = new HashMap();
            			velocityContext.put("issueInstant", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'+02:00'").print(new org.joda.time.DateTime()));
            			velocityContext.put("requestId", IdGeneratorFactory.getIdGenerator("uuid").generateId());
            			velocityContext.put("currentDate", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime()));
            			velocityContext.put("generatedChars1", RandomStringUtils.randomAlphabetic(10).toLowerCase());
            			velocityContext.put("generatedChars2", RandomStringUtils.randomAlphabetic(10).toLowerCase());
            
            RegisterPersonRequest request = (RegisterPersonRequest) FileTestUtils.toObject(velocityContext, testRequestFileLocation, typeof(RegisterPersonRequest));
            return ConsultrnSessionServiceFactory.getConsultrnSession().registerPerson(request);
        }
		
		private be.fgov.ehealth.consultrn._1_0.protocol.SearchBySSINRequest createSearchBySsinRequest(string applicationId, string ssin, string qualityCode,
		                                                                                              org.joda.time.DateTime beginDate, org.joda.time.DateTime endDate) {
			SearchBySSINRequest searchBySSINRequest = createSearchBySsinRequest(applicationId, ssin, qualityCode);
			be.fgov.ehealth.commons._1_0.core.PeriodType periodType = new be.fgov.ehealth.commons._1_0.core.PeriodType();
			periodType.setBeginDate(beginDate);
			periodType.setEndDate(endDate);
			searchBySSINRequest.getInscription().setPeriod(periodType);
			return searchBySSINRequest;
		}
		
		private SearchBySSINRequest createSearchBySsinRequest(string applicationId, string ssin, string qualityCode) {
			SearchBySSINRequest searchBySSINRequest = new SearchBySSINRequest();
			searchBySSINRequest.setApplicationID(applicationId);
			be.fgov.ehealth.consultrn._1_0.core.InscriptionType inscription = new be.fgov.ehealth.consultrn._1_0.core.InscriptionType();
			be.fgov.ehealth.consultrn._1_0.core.EncodedSSINType encodedSSINType = new be.fgov.ehealth.consultrn._1_0.core.EncodedSSINType();
			encodedSSINType.setValue(ssin);
			inscription.setSSIN(encodedSSINType);
			inscription.setQualityCode(qualityCode);
			searchBySSINRequest.setInscription(inscription);
			return searchBySSINRequest;
		}
		
		private SearchPhoneticRequest createSearchPhoneticRequest(string applicationId, string lastName, string firstName,
		                                                          string birthDate) {
			SearchPhoneticRequest searchPhoneticRequest = new SearchPhoneticRequest();
			searchPhoneticRequest.setApplicationID(applicationId);
			PhoneticCriteriaType phoneticCriteriaType = new PhoneticCriteriaType();
			phoneticCriteriaType.setLastName(lastName);
			phoneticCriteriaType.setFirstName(firstName);
			phoneticCriteriaType.setBirthDate(birthDate);
			searchPhoneticRequest.setPhoneticCriteria(phoneticCriteriaType);
			return searchPhoneticRequest;
		}
	}
	
}