﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.businessconnector.ehboxv3.service;
using be.ehealth.technicalconnector.session;
using NUnit.Framework;
using java.util;
using be.ehealth.businessconnector.ehbox.api.domain;
using be.ehealth.businessconnector.ehbox.v3;
using be.ehealth.businessconnector.ehbox.v3.util;
using be.ehealth.businessconnector.ehbox.v3.builders;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.fgov.ehealth.ehbox.consultation.protocol.v3;
using be.fgov.ehealth.ehbox.core.v3;
using be.fgov.ehealth.ehbox.publication.protocol.v3;

namespace be.ehealth.businessconnector.ehboxv3.service
{
    [TestFixture]
    public class AbstractEhboxV3ServiceIntegration
    {
        private static String FILE_AS_DOC = ".\\be.ehealth.businessconnector.ehboxv3.test.properties";

        private static BoxIdType alternativeMailBox;
        
        /**
         * @return the alternativeMailBox
         */
        public static BoxIdType getAlternativeMailBox() {
            return alternativeMailBox;
        }
        
        private static String oldNewsMessageIdDefaultBox;
        
        private static String newsMessageIdDefaultBox;
        
        private static String documentMessageIdDefaultBox;
        
        private static String oldNewsMessageIdAlternativeBox;
        
        private static String newsMessageIdAlternativeBox;
        
        private static String documentMessageIdAlternativeBox;
        
        private static bool isDoctorTest = false;
        
        public static void initializeMailboxesInKnownCondition() {
            SessionInitializer.init(FILE_AS_DOC, SupportedLanguages.NET.getAbbreviation());
            isDoctorTest = EhboxTestUtilities.isDoctorTest(FILE_AS_DOC);
            // current test setup doesn't work for organisations
            Assume.That( isDoctorTest == true);
            alternativeMailBox = EhboxTestDataBuilder.GetEhboxSender();
            resetAllMessageIds();
            initializeMailbox(alternativeMailBox);
            initializeMailbox(null);
        }
        
        [TearDown]
        public static void tearDown() {
            Session.getInstance().unloadSession();
        }
        
        public static String getCreatedNewsIdForMailbox(BoxIdType mailBox) {
            if (mailBox == null) {
                return newsMessageIdDefaultBox;
            } else {
                return newsMessageIdAlternativeBox;
            }
        }
        
        public static String getCreatedDocumentIdForMailbox(BoxIdType mailBox) {
            if (mailBox == null) {
                return documentMessageIdDefaultBox;
            } else {
                return documentMessageIdAlternativeBox;
            }
        }
        
        public static String getCreatedOldNewsIdForMailbox(BoxIdType mailBox) {
            if (mailBox == null) {
                return oldNewsMessageIdDefaultBox;
            } else {
                return oldNewsMessageIdAlternativeBox;
            }
        }
        
        public java.util.List getAllCreatedMessageIds() {
            java.util.ArrayList result = new java.util.ArrayList();
            result.add(documentMessageIdAlternativeBox);
            result.add(documentMessageIdDefaultBox);
            result.add(newsMessageIdAlternativeBox);
            result.add(newsMessageIdDefaultBox);
            return result;
        }
        
        /**
         * 
         */
        private static void resetAllMessageIds() {
            oldNewsMessageIdDefaultBox = null;
            newsMessageIdDefaultBox = null;
            documentMessageIdDefaultBox = null;
            oldNewsMessageIdAlternativeBox = null;
            newsMessageIdAlternativeBox = null;
            documentMessageIdAlternativeBox = null;
        }
        
        
        /**
         * @param boxId
         * @throws Exception
         */
        private static void initializeMailbox(BoxIdType boxId) {
            
            // send 2 newsMessages
            Addressee addresseeForBoxIdType = EhboxTestUtilities.mapBoxIdTypeToAddressee(boxId);
            NewsMessage fullExampleNewsMessage = EhboxTestDataBuilder.buildFullExampleNewsMessage(true, true, addresseeForBoxIdType);
            fullExampleNewsMessage.getDocument().setTitle("ConnectorTest : originalNews:boxId=" + boxId);
            SendMessageResponse sendMessageResponseNews1 = be.ehealth.businessconnector.ehbox.v3.session.ServiceFactory.getEhealthBoxServiceV3().sendMessage(BuilderFactory.getSendMessageBuilder().buildMessage(fullExampleNewsMessage));
            String publicationId = sendMessageResponseNews1.getSentPublicationId();
            String oldNewsId = sendMessageResponseNews1.getId();
            fullExampleNewsMessage.getDocument().setTitle("ConnectorTest : changedNewsTitle:boxId=" + boxId);
            SendMessageResponse sendMessageResponseNewsUpdate = be.ehealth.businessconnector.ehbox.v3.session.ServiceFactory.getEhealthBoxServiceV3().sendMessage(BuilderFactory.getSendMessageBuilder().buildMessage(fullExampleNewsMessage));
            String newsId = sendMessageResponseNewsUpdate.getId();
            Assert.AreEqual(publicationId, sendMessageResponseNewsUpdate.getSentPublicationId());
            
            
            DocumentMessage fullExampleDocumentMessage = EhboxTestDataBuilder.buildFullExampleDocumentMessage(true, true, addresseeForBoxIdType);
            SendMessageResponse sendMessageResponseDocument = be.ehealth.businessconnector.ehbox.v3.session.ServiceFactory.getEhealthBoxServiceV3().sendMessage(BuilderFactory.getSendMessageBuilder().buildMessage(fullExampleDocumentMessage));
            String documentId = sendMessageResponseDocument.getId();
            
            if (boxId == null) {
                newsMessageIdDefaultBox = newsId;
                documentMessageIdDefaultBox = documentId;
                oldNewsMessageIdDefaultBox = oldNewsId;
            } else {
                newsMessageIdAlternativeBox = newsId;
                documentMessageIdAlternativeBox = documentId;
                oldNewsMessageIdAlternativeBox = oldNewsId;
            }
            
            int sleepTimeInMillis = 3000;
            java.lang.Thread.sleep(sleepTimeInMillis);
            java.util.List messagesInInbox = getListOfMessagesForSource("INBOX", boxId);
            Assert.False(messagesInInbox.isEmpty(), "there should be some messages in the inbox");
            Assert.True(messagesInInbox.contains(newsId), "newsId should be in inbox");
            Assert.True(messagesInInbox.contains(documentId), "documentId should be in inbox");
            
            
        }
        
        /**
         * @param source
         * @throws ConnectorException
         * @throws TechnicalConnectorException
         */
        protected static java.util.List getListOfMessagesForSource(String source, BoxIdType ehboxToUse) {
            GetMessageListResponseType messageList = be.ehealth.businessconnector.ehbox.v3.session.ServiceFactory.getEhealthBoxServiceV3().getMessageList(BuilderFactory.getRequestBuilder().createGetMessagesListRequest(source, 1, 100, ehboxToUse));
            java.util.ArrayList listOfMessageIds = getListOfMessageIdsFromResponse(messageList);
            logMessageList(source, messageList.getMessages());
            return listOfMessageIds;
        }
        
        
        /**
         * @param source
         * @param messages
         */
        protected static void logMessageList(String source, java.util.List messages) {
            for (int i = 0; i < messages.size(); i++) {
                be.fgov.ehealth.ehbox.consultation.protocol.v3.Message message = (be.fgov.ehealth.ehbox.consultation.protocol.v3.Message)messages.get(i);
                EhboxTestUtilities.logMessage(message);
            }
            
        }
        
        /**
         * @param messageList
         * @return
         */
        public static java.util.ArrayList getListOfMessageIdsFromResponse(GetMessageListResponseType messageList) {
            java.util.ArrayList listOfMessageIds = new java.util.ArrayList();
            for (int i = 0; i<messageList.getMessages().size(); i++) {
                be.fgov.ehealth.ehbox.consultation.protocol.v3.Message message = (be.fgov.ehealth.ehbox.consultation.protocol.v3.Message)messageList.getMessages().get(i);
                listOfMessageIds.add(message.getMessageId());
            }
            logMessageList(messageList.getSource(), messageList.getMessages());
            return listOfMessageIds;
        }
        
        
        /**
         * @param source
         * @param fullListOfIds
         */
        public static void logList(String source, java.util.List fullListOfIds) {
            java.lang.StringBuilder sb = new java.lang.StringBuilder(source + " :");
            for (int i = 0; i < fullListOfIds.size(); i++) {
                String messageId = (String)fullListOfIds.get(i);
                sb.append(messageId).append(" ");
            }
            System.Console.WriteLine("logList : " + sb.toString());
        }
        
        
        /**
         * @param messageId
         * @param msg
         */
        public void checkMessageIdEqualsCreatedMessage(String messageId, be.ehealth.businessconnector.ehbox.api.domain.Message msg, BoxIdType mailBoxToUse) {
            if (msg.GetType() == typeof(NewsMessage)) {
                messageId.Equals(getCreatedNewsIdForMailbox(mailBoxToUse));
            } else if (msg.GetType() == typeof(DocumentMessage)) {
                messageId.Equals(getCreatedDocumentIdForMailbox(mailBoxToUse));
            }
        }
    }
}
