/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.wsconsent.utils;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.hubservices.core.v2.PatientIdType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENT;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENTschemes;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;


/**
 * utility methods for the testing of wsconsent.
 * 
 * @author EHP
 * 
 * 
 * 
 */
public final class TestUtils {

    private static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);


    /**
     * private constructor : only static methods on this class should be used.
     */
    private TestUtils() {
        super();
    }

    /**
     * Method which creates a dummy patient.
     * 
     * @return
     */
    public static PatientIdType createDummyPatient() {

        PatientIdType patient = new PatientIdType();
        // Ask Matching

        patient.setName("dummyPatient");
        patient.setFamilyname("dummyFamilyName");
        patient.setFirstname("john");

        be.fgov.ehealth.standards.kmehr.id.v1.ObjectFactory objectFactoryIdPatient = new be.fgov.ehealth.standards.kmehr.id.v1.ObjectFactory();
        IDPATIENT idPatient = objectFactoryIdPatient.createIDPATIENT();
        idPatient.setSV("1.0");
        idPatient.setS(IDPATIENTschemes.INSS);
        idPatient.setValue("123456789");


        IDPATIENT idPatient2 = objectFactoryIdPatient.createIDPATIENT();
        idPatient2.setSV("1.0");
        idPatient2.setS(IDPATIENTschemes.EID_CARDNO);
        idPatient2.setValue("123456789");

        patient.getIds().add(idPatient);
        patient.getIds().add(idPatient2);

        return patient;
    }

    /**
     * @param consentRequest
     */
    public static <T> void logJaxbObject(T consentRequest) {
        String xmlString = convertJaxbObjectToString(consentRequest);
        LOG.debug("logging jaxb ojbect : " + xmlString);
    }

    /**
     * @param consentRequest
     * @return
     */
    private static <T> String convertJaxbObjectToString(T consentRequest) {
        @SuppressWarnings("unchecked")
        Class<T> clazz = (Class<T>) consentRequest.getClass();
        MarshallerHelper<T, T> marshaller = new MarshallerHelper<T, T>(clazz, clazz);
        String xmlString = marshaller.toString(consentRequest);
        return xmlString;
    }

    public static <T> void assertXmlSimular(String fileLocation, T actual) throws SAXException, IOException, TechnicalConnectorException {
        String expected = ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream(fileLocation));
        String xmlString = convertJaxbObjectToString(actual);

        XmlAsserter.assertSimilar(expected, xmlString);
    }

}
