/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.policies.EncryptionPolicy;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKEKRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.util.encoders.Base64;

final class CmsEncrypter {
    private static final Logger LOGGER = Logger.getLogger(CmsEncrypter.class);
    private final ASN1ObjectIdentifier privateKeyContentEncryptionAlgorithm;
    private final ASN1ObjectIdentifier secretKeyContentEncryptionAlgorithm;

    CmsEncrypter(EncryptionPolicy publicKeyEncryptionPolicy, EncryptionPolicy secretKeyEncryptionPolicy) {
        this.privateKeyContentEncryptionAlgorithm = new ASN1ObjectIdentifier(publicKeyEncryptionPolicy.getContentEncryptionAlgorithmOID());
        this.secretKeyContentEncryptionAlgorithm = new ASN1ObjectIdentifier(secretKeyEncryptionPolicy.getContentEncryptionAlgorithmOID());
    }

    byte[] encryptData(byte[] dataToBeEncrypted, X509Certificate encryptionCertificate) throws CertificateEncodingException, IOException, CMSException {
        return this.encryptData(dataToBeEncrypted, encryptionCertificate == null ? null : Collections.singletonList(encryptionCertificate));
    }

    byte[] encryptData(byte[] dataToBeEncrypted, List<X509Certificate> encryptionCertificates) throws CertificateEncodingException, IOException, CMSException {
        Preconditions.checkNotEmpty(encryptionCertificates, "The encryptionCertificates may not be null or empty.");
        return this.encrypt(dataToBeEncrypted, encryptionCertificates, null, null);
    }

    byte[] encryptData(byte[] dataToBeEncrypted, SecretKey kek, String base64EncodedKekId) throws CertificateEncodingException, IOException, CMSException {
        Preconditions.checkNotNull(kek, "The KEK may not be null.");
        Preconditions.checkNotNull(base64EncodedKekId, "The KEK ID may not be null.");
        return this.encrypt(dataToBeEncrypted, null, kek, base64EncodedKekId);
    }

    byte[] encryptData(byte[] dataToBeEncrypted, List<X509Certificate> encryptionCertificates, SecretKey kek, String base64EncodedKekId) throws CertificateEncodingException, IOException, CMSException {
        Preconditions.checkNotNull(kek, "The KEK may not be null.");
        Preconditions.checkNotNull(base64EncodedKekId, "The KEK ID may not be null.");
        return this.encrypt(dataToBeEncrypted, encryptionCertificates, kek, base64EncodedKekId);
    }

    OutputStream openDataToBeEncryptedStream(OutputStream encryptedDataStream, List<X509Certificate> encryptionCertificates, SecretKey kek, String base64EncodedKekId) throws CertificateEncodingException, CMSException, IOException {
        Preconditions.checkNotNull(encryptedDataStream, "Given encryptedDataStream must not be null.");
        if ((encryptionCertificates == null || encryptionCertificates.isEmpty()) && kek == null) {
            throw new IllegalArgumentException("At least one addressee (known or unknown) must be given.)");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Encrypting data stream ..");
        }
        CMSEnvelopedDataStreamGenerator envelopedDataGen = new CMSEnvelopedDataStreamGenerator();
        this.addKeyTransRecipientInfo(encryptionCertificates, (CMSEnvelopedGenerator)envelopedDataGen);
        this.addKEKRecipientInfo(kek, base64EncodedKekId, (CMSEnvelopedGenerator)envelopedDataGen);
        return envelopedDataGen.open(encryptedDataStream, this.createOutputEncryptor(kek));
    }

    private byte[] encrypt(byte[] dataToBeEncrypted, List<X509Certificate> encryptionCertificates, SecretKey kek, String base64EncodedKekId) throws CertificateEncodingException, IOException, CMSException {
        Preconditions.checkNotNull(dataToBeEncrypted, "The DataToBeEncrypted may not be null.");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Encrypting data " + dataToBeEncrypted.length + " bytes.."));
        }
        CMSEnvelopedDataGenerator envelopedDataGen = new CMSEnvelopedDataGenerator();
        this.addKeyTransRecipientInfo(encryptionCertificates, (CMSEnvelopedGenerator)envelopedDataGen);
        this.addKEKRecipientInfo(kek, base64EncodedKekId, (CMSEnvelopedGenerator)envelopedDataGen);
        return envelopedDataGen.generate((CMSTypedData)new CMSProcessableByteArray(dataToBeEncrypted), this.createOutputEncryptor(kek)).getEncoded();
    }

    private void addKeyTransRecipientInfo(List<X509Certificate> encryptionCertificates, CMSEnvelopedGenerator envelopedDataGen) throws CertificateEncodingException {
        if (encryptionCertificates != null) {
            for (X509Certificate encryptionCertificate : encryptionCertificates) {
                LOGGER.debug((Object)("Recipient: " + encryptionCertificate.getSubjectX500Principal().getName()));
                envelopedDataGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(encryptionCertificate));
            }
        }
    }

    private void addKEKRecipientInfo(SecretKey kek, String base64EncodedKekId, CMSEnvelopedGenerator envelopedDataGen) {
        if (kek != null) {
            Preconditions.checkNotNull(base64EncodedKekId, "The kekId may not be null when providing a KEK.");
            LOGGER.debug((Object)("KEK Id (Base64): " + base64EncodedKekId));
            envelopedDataGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKEKRecipientInfoGenerator(Base64.decode((String)base64EncodedKekId), kek));
        }
    }

    private OutputEncryptor createOutputEncryptor(SecretKey kek) throws CMSException {
        return kek == null ? new JceCMSContentEncryptorBuilder(this.privateKeyContentEncryptionAlgorithm).build() : new JceCMSContentEncryptorBuilder(this.secretKeyContentEncryptionAlgorithm).build();
    }
}

