/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.utils.impl;

import java.security.KeyStore;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import be.ehealth.technicalconnector.service.etee.CryptoFactory;
import be.ehealth.technicalconnector.service.etee.impl.ConnectorRevocationStatusChecker;
import be.ehealth.technicalconnector.service.sts.security.impl.BeIDCredential;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;


/**
 * Integration test for {@link OcspRevocationStatusChecker}.
 * 
 * @author EHP
 */
public class OcspRevocationStatusCheckerUserIntegrationTest {

    @Before
    public void before() throws Exception {
        KeyStore store = (KeyStore) CryptoFactory.getOCSPOptions().get(OCSPOption.TRUST_STORE);
        store.setCertificateEntry("ca", BeIDCredential.getInstance("test", BeIDCredential.EID_AUTH_ALIAS).getCertificateChain()[1]);
        store.setCertificateEntry("ca2", BeIDCredential.getInstance("test", BeIDCredential.EID_AUTH_ALIAS).getCertificateChain()[2]);
        CryptoFactory.getOCSPOptions().put(OCSPOption.TRUST_STORE, store);
    }


    @After
    public void after() throws Exception {
        KeyStore store = (KeyStore) CryptoFactory.getOCSPOptions().get(OCSPOption.TRUST_STORE);
        store.deleteEntry("ca");
        store.deleteEntry("ca2");
        CryptoFactory.getOCSPOptions().put(OCSPOption.TRUST_STORE, store);
    }


    @Test
    public void testWithEid() throws Exception {
        ConnectorRevocationStatusChecker checker = new ConnectorRevocationStatusChecker();
        boolean isRevoked = checker.isRevoked(BeIDCredential.getInstance("test", BeIDCredential.EID_AUTH_ALIAS).getCertificate());
        Assert.assertFalse("Certificate is revoked.", isRevoked);
    }
}
