/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.ocsp;

import be.fgov.ehealth.etee.crypto.ocsp.OCSPException;
import be.fgov.ehealth.etee.crypto.ocsp.UriStreamProvider;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.log4j.Logger;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;

class OCSPConnector {
    private static final Logger LOGGER = Logger.getLogger(OCSPConnector.class);
    private static final int HTTP_OK_RESPONSE_CODE = 200;
    private final UriStreamProvider streamProvider;

    public OCSPConnector(int connectTimeout, int readTimeout, boolean isUserInteractionAllowed) {
        this.streamProvider = new UriStreamProvider(connectTimeout, readTimeout, isUserInteractionAllowed);
    }

    public OCSPResp send(OCSPReq ocspRequest, URI uri) throws OCSPException {
        HttpURLConnection con = this.getConnection(this.buildURL(uri));
        this.sendOCSPRequest(ocspRequest, con);
        this.validateHTTPResponse(con);
        return this.getOCSPResponse(con);
    }

    private OCSPResp getOCSPResponse(HttpURLConnection con) throws OCSPException {
        OCSPResp ocspResponse;
        InputStream in = this.getInputStream(con);
        try {
            ocspResponse = new OCSPResp(in);
        }
        catch (IOException e) {
            throw new OCSPException("Failed to build OCSPResponse object from the the OCSP service response stream.", e);
        }
        return ocspResponse;
    }

    private InputStream getInputStream(HttpURLConnection con) throws OCSPException {
        InputStream in;
        try {
            in = (InputStream)con.getContent();
        }
        catch (IOException e) {
            throw new OCSPException("Failed to retrieve content from the OCSP service.", e);
        }
        return in;
    }

    private void validateHTTPResponse(HttpURLConnection con) throws OCSPException {
        try {
            if (con.getResponseCode() != 200) {
                LOGGER.error((Object)("OCSP response code is NOK. Response code = " + con.getResponseCode()));
                throw new OCSPException("OCSP Service could not process the OCSP Request.");
            }
        }
        catch (IOException e) {
            throw new OCSPException("Failed to connect to the OCSP service.", e);
        }
    }

    private void sendOCSPRequest(OCSPReq ocspRequest, HttpURLConnection con) throws OCSPException {
        OutputStream out = this.getOutputStream(con);
        DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
        try {
            dataOut.write(ocspRequest.getEncoded());
            dataOut.flush();
            dataOut.close();
        }
        catch (IOException e) {
            throw new OCSPException("Failed to send The OCSP request to the OCSP service.", e);
        }
    }

    private OutputStream getOutputStream(HttpURLConnection con) throws OCSPException {
        OutputStream out;
        try {
            out = con.getOutputStream();
        }
        catch (IOException e) {
            throw new OCSPException("Failed to retrieve a response stream from the OCSP service.", e);
        }
        return out;
    }

    private URL buildURL(URI uri) throws OCSPException {
        URL ocspURL;
        try {
            ocspURL = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new OCSPException("OCSP Service URI is not an URL", e);
        }
        return ocspURL;
    }

    private HttpURLConnection getConnection(URL ocspURL) throws OCSPException {
        HttpURLConnection con = null;
        try {
            con = this.streamProvider.getConnection(ocspURL);
        }
        catch (IOException e) {
            throw new OCSPException("No connection could be established to the URL.", e);
        }
        con.setRequestProperty("Content-Type", "application/ocsp-request");
        con.setRequestProperty("Accept", "application/ocsp-response");
        con.setDoOutput(true);
        return con;
    }
}

