/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.tarification.service;

import be.ehealth.business.common.util.HandlerChainUtil;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.TokenType;

public final class ServiceFactory {
    private static final String PROP_ENDPOINT_TARIFICATION_MYCARENET_V1 = "endpoint.mcn.tarification";
    private static final String PROP_VALIDATION_INCOMING_CONS_TARIFICATION_MYCARENET = "validation.incoming.message.mcn.tarification";
    private static final String PROP_ENDPOINT_TARIFICATION_MEDIPRIMA_V1 = "endpoint.mcn.tarificationmediprima";
    private static final String PROP_VALIDATION_INCOMING_CONS_TARIFICATION_MEDIPRIMA = "validation.incoming.message.mcn.tarificationmediprima";
    protected static final String TARIFICATION_PROT = "/ehealth-mycarenet-tarification/XSD/mycarenet-tarification-protocol-1_0.xsd";
    private static Configuration config = ConfigFactory.getConfigValidator();

    private ServiceFactory() {
    }

    @Deprecated
    public static GenericRequest getTarificationService(SAMLToken token) throws TechnicalConnectorException {
        return ServiceFactory.getTarificationSessionForMycarenet(token);
    }

    public static GenericRequest getTarificationSessionForMediPrima(SAMLToken token) throws TechnicalConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint("https://services-acpt.ehealth.fgov.be/beta/MyCareNet/TarificationMediPrima/v1");
        genReq.setSoapAction("urn:be:fgov:ehealth:mycarenet:tarification:protocol:v1:TarificationConsult");
        genReq.setCredential((Credential)token, TokenType.SAML);
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(HandlerChainUtil.buildChainWithValidator((String)PROP_VALIDATION_INCOMING_CONS_TARIFICATION_MEDIPRIMA, (String[])new String[]{TARIFICATION_PROT}));
        return genReq;
    }

    public static GenericRequest getTarificationSessionForMycarenet(SAMLToken token) throws TechnicalConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_TARIFICATION_MYCARENET_V1, "$uddi{uddi:ehealth-fgov-be:business:mycarenettarification:v1}"));
        genReq.setSoapAction("urn:be:fgov:ehealth:mycarenet:tarification:protocol:v1:TarificationConsult");
        genReq.setCredential((Credential)token, TokenType.SAML);
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(HandlerChainUtil.buildChainWithValidator((String)PROP_VALIDATION_INCOMING_CONS_TARIFICATION_MYCARENET, (String[])new String[]{TARIFICATION_PROT}));
        return genReq;
    }
}

