/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.hub.service.impl;

import be.ehealth.businessconnector.hub.builders.BuilderFactory;
import be.ehealth.businessconnector.hub.builders.RequestBuilderComplete;
import be.ehealth.businessconnector.hub.exception.IntraHubBusinessConnectorException;
import be.ehealth.businessconnector.hub.service.IntraHubService;
import be.ehealth.businessconnector.hub.service.IntraHubTransactionService;
import be.ehealth.businessconnector.hub.service.impl.IntraHubAbstract;
import be.ehealth.businessconnector.hub.validators.HubReplyValidator;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.hubservices.core.v1.DeclareTransactionRequest;
import be.fgov.ehealth.hubservices.core.v1.DeclareTransactionResponse;
import be.fgov.ehealth.hubservices.core.v1.GetTransactionListRequest;
import be.fgov.ehealth.hubservices.core.v1.GetTransactionListResponse;
import be.fgov.ehealth.hubservices.core.v1.GetTransactionRequest;
import be.fgov.ehealth.hubservices.core.v1.GetTransactionResponse;
import be.fgov.ehealth.hubservices.core.v1.KmehrHeaderDeclareTransaction;
import be.fgov.ehealth.hubservices.core.v1.KmehrHeaderGetTransactionList;
import be.fgov.ehealth.hubservices.core.v1.LocalSearchType;
import be.fgov.ehealth.hubservices.core.v1.PatientIdType;
import be.fgov.ehealth.hubservices.core.v1.PutTransactionRequest;
import be.fgov.ehealth.hubservices.core.v1.PutTransactionResponse;
import be.fgov.ehealth.hubservices.core.v1.RequestPublicationRequest;
import be.fgov.ehealth.hubservices.core.v1.RequestPublicationResponse;
import be.fgov.ehealth.hubservices.core.v1.RevokeTransactionRequest;
import be.fgov.ehealth.hubservices.core.v1.RevokeTransactionResponse;
import be.fgov.ehealth.hubservices.core.v1.TransactionBaseType;
import be.fgov.ehealth.hubservices.core.v1.TransactionIdType;
import be.fgov.ehealth.hubservices.core.v1.TransactionWithPeriodType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDKMEHR;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import java.util.List;

public class IntraHubTransactionServiceImpl
extends IntraHubAbstract
implements IntraHubTransactionService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private RequestBuilderComplete builder;

    public IntraHubTransactionServiceImpl(IntraHubService hubService, HubReplyValidator validator) throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        super(hubService, validator);
        this.builder = BuilderFactory.getInstance().getRequestBuilderComplete();
    }

    public IntraHubTransactionServiceImpl() {
    }

    @Override
    public List<IDKMEHR> declareTransaction(KmehrHeaderDeclareTransaction input) throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        DeclareTransactionRequest request = this.builder.buildDeclareTransactionRequest(input);
        DeclareTransactionResponse response = this.getService().declareTransaction(token, request);
        this.getReplyValidator().validate(response.getAcknowledge());
        return response.getTransaction().getIds();
    }

    @Override
    public void putTransaction(Kmehrmessage input) throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        PutTransactionRequest request = this.builder.buildPutTransactionRequest(input);
        PutTransactionResponse response = this.getService().putTransaction(token, request);
        this.getReplyValidator().validate(response.getAcknowledge());
    }

    @Override
    public void revokeTransaction(PatientIdType patient, TransactionIdType transaction) throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        RevokeTransactionRequest request = this.builder.buildRevokeTransactionRequest(patient, transaction);
        RevokeTransactionResponse response = this.getService().revokeTransaction(token, request);
        this.getReplyValidator().validate(response.getAcknowledge());
    }

    @Override
    public KmehrHeaderGetTransactionList getTransactionList(PatientIdType patient, LocalSearchType searchType, TransactionWithPeriodType transaction) throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        GetTransactionListRequest request = this.builder.buildGetTransactionListRequest(patient, searchType, transaction);
        GetTransactionListResponse response = this.getService().getTransactionList(token, request);
        this.getReplyValidator().validate(response.getAcknowledge());
        return response.getKmehrheader();
    }

    @Override
    public Kmehrmessage getTransaction(PatientIdType patient, TransactionBaseType transaction) throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        GetTransactionRequest request = this.builder.buildGetTransactionRequest(patient, transaction);
        GetTransactionResponse response = this.getService().getTransaction(token, request);
        this.getReplyValidator().validate(response.getAcknowledge());
        return response.getKmehrmessage();
    }

    @Override
    public void requestPublication(PatientIdType patient, TransactionWithPeriodType transaction, String comment) throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        RequestPublicationRequest request = this.builder.buildRequestPublicationRequest(patient, transaction, comment);
        RequestPublicationResponse response = this.getService().requestPublication(token, request);
        this.getReplyValidator().validate(response.getAcknowledge());
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeclareTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeclareTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionListRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionListResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{KmehrHeaderDeclareTransaction.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{KmehrHeaderGetTransactionList.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{PutTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RequestPublicationRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RequestPublicationResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RevokeTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{TransactionBaseType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{TransactionIdType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{TransactionWithPeriodType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{Kmehrmessage.class});
    }
}

