/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.bootstrap.bcp;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.EndpointUpdateRule;


/**
 * @author EH053
 *
 */
public class EndpointUpdaterTest {

    @Rule
    public EndpointUpdateRule rule = new EndpointUpdateRule("/tsl-samples/local/servicelist-local");


    @Test
    public void activeEndpoint() throws Exception {
        EndpointDistributor distributor = EndpointDistributor.getInstance();
        Assert.assertEquals("http://localhost:6666/error/403", distributor.getActiveEndpoint("http://localhost:6666/echo"));
    }

    @Test
    public void nextEndpoint() throws Exception {
        EndpointDistributor distributor = EndpointDistributor.getInstance();
        Assert.assertEquals("http://localhost:6666/error/403", distributor.getActiveEndpoint("http://localhost:6666/echo"));
        distributor.activateNextEndPoint(distributor.getActiveEndpoint("http://localhost:6666/error/403"));
        Assert.assertEquals("http://localhost:6666/echo", distributor.getActiveEndpoint("http://localhost:6666/echo"));
    }

    @Test
    public void loopOverEndpoints() throws Exception {
        String active_endpoint = "http://localhost:7777/error/404";
        String alt01_endpoint = "http://localhost:7777/timeout/60";
        String alt02_endpoint = "http://localhost:7777/soap/error/business";
        EndpointDistributor distributor = EndpointDistributor.getInstance();
        for (int i = 0; i < 3; i++) {
            Assert.assertEquals(active_endpoint, distributor.getActiveEndpoint(active_endpoint));
            distributor.activateNextEndPoint(distributor.getActiveEndpoint(active_endpoint));
            Assert.assertEquals(alt01_endpoint, distributor.getActiveEndpoint(active_endpoint));
            distributor.activateNextEndPoint(distributor.getActiveEndpoint(active_endpoint));
            Assert.assertEquals(alt02_endpoint, distributor.getActiveEndpoint(active_endpoint));
            distributor.activateNextEndPoint(distributor.getActiveEndpoint(active_endpoint));
        }
    }


}
