/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config;

import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.config.impl.ConfigValidatorImpl;
import be.ehealth.technicalconnector.config.impl.ConfigurationImpl;
import be.ehealth.technicalconnector.config.util.ConfigUtil;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigFactory {
    public static final String SYSTEM_PROP_CONFIG_LOCATION = "be.ehealth.technicalconnector.config.location";
    public static final String DEFAULT_CONFIG = "/be.ehealth.technicalconnector.properties";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFactory.class);
    private static final Map<Set<String>, ConfigValidator> CACHE = new HashMap<Set<String>, ConfigValidator>();
    private static String configLocation = "/be.ehealth.technicalconnector.properties";

    private ConfigFactory() {
        throw new UnsupportedOperationException();
    }

    public static ConfigValidator getConfigValidator() {
        return ConfigFactory.getConfigValidator(null);
    }

    public static ConfigValidator getConfigValidator(List<String> expectedProps) {
        TreeSet<String> cacheKey = new TreeSet<String>();
        if (expectedProps != null) {
            cacheKey.addAll(expectedProps);
        }
        if (!CACHE.containsKey(cacheKey)) {
            LOG.debug("Adding ConfigValidator to cache with expectedProps " + StringUtils.join(cacheKey, (String)","));
            CACHE.put(cacheKey, new ConfigValidatorImpl(expectedProps));
        }
        return CACHE.get(cacheKey);
    }

    public static ConfigValidator getConfigValidatorFor(String ... expectedProps) {
        if (expectedProps == null) {
            throw new IllegalArgumentException("getConfigValidatorFor cannot have a null parameter");
        }
        return ConfigFactory.getConfigValidator(Arrays.asList(expectedProps));
    }

    public static void invalidate() {
        for (ConfigValidator validator : CACHE.values()) {
            validator.invalidateCache();
        }
    }

    public static String getConfigLocation() throws TechnicalConnectorException {
        if (System.getProperties().containsKey(SYSTEM_PROP_CONFIG_LOCATION)) {
            return System.getProperty(SYSTEM_PROP_CONFIG_LOCATION);
        }
        return configLocation;
    }

    public static void setConfigLocation(String configLocation) throws TechnicalConnectorException {
        String locationToSet = configLocation;
        if (locationToSet == null) {
            locationToSet = ConfigUtil.isNet() ? StringUtils.replace((String)DEFAULT_CONFIG, (String)"/", (String)".\\") : DEFAULT_CONFIG;
        }
        ConnectorIOUtils.getResourceFilePath(locationToSet);
        ConfigFactory.configLocation = locationToSet;
        ConfigurationImpl.reset();
        ConfigFactory.invalidate();
    }

    public static void setLocation(InputStream is) throws TechnicalConnectorException {
        Validate.notNull((Object)is);
        FileOutputStream fos = null;
        try {
            File file = File.createTempFile("inputStream", ".properties");
            file.deleteOnExit();
            fos = new FileOutputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            prop.store(fos, "Config loaded from inputstream");
            ConfigFactory.setConfigLocation(file.getAbsolutePath());
        }
        catch (IOException e) {
            try {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_IOEXCEPTION, "Problem with the temporary file inputstream.properties", e);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)fos);
    }
}

