/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.dicsv2.service;

import static org.junit.Assert.assertTrue;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.businessconnector.dicsv2.service.ServiceFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.testcommons.SessionTestUtils;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * tests the {@link ServiceFactory} offline.
 * 
 * @author EH076
 */
public class ServiceFactoryTest {

    @BeforeClass
    public static void initializeDummySession() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.dicsv2.test.properties", false);
        Session.setSessionManager(SessionTestUtils.getDummySessionManager());
    }

    @AfterClass
    public static void destroyDummySession() {
        Session.setSessionManager(null);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.dicsv2.service.ServiceFactory#getDicsService(be.ehealth.technicalconnector.service.sts.security.SAMLToken, java.lang.String)}
     * .
     */
    @Test(expected = IllegalArgumentException.class)
    public void testGetDicsServiceOnlyNullValueInput() throws TechnicalConnectorException {
        ServiceFactory.getDicsService(null, null);
    }

    @Test(expected = IllegalArgumentException.class)
    public void testGetDicsServiceNoSoapAction() throws TechnicalConnectorException {
        ServiceFactory.getDicsService(SessionTestUtils.getDummyToken(), null);
    }

    @Test
    public void testGetDicsService() throws TechnicalConnectorException {
        ServiceFactory.getDicsService(SessionTestUtils.getDummyToken(), "dummySoapAction");
    }

    @Test
    public void testConstructorIsPrivate() throws Exception {
        Constructor<ServiceFactory> constructor = ServiceFactory.class.getDeclaredConstructor();
        assertTrue("Constructor is not private", Modifier.isPrivate(constructor.getModifiers()));

        constructor.setAccessible(true);
        try {
            constructor.newInstance();
            Assert.fail("should have thrown UnsupportedOperationException");
        } catch (InvocationTargetException e) {
            Assert.assertTrue(e.getTargetException() instanceof UnsupportedOperationException);
            UnsupportedOperationException usoe = (UnsupportedOperationException) e.getTargetException();
            Assert.assertEquals("class may not be initialized, only static methods should be used", usoe.getMessage());
        }
    }


}
