/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.mycarenetcommons.validator;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.business.mycarenetcommons.exception.ConnectorValidationException;
import be.fgov.ehealth.mycarenet.commons.core.v2.CommonOutputType;


/**
 * Test the validator of common output
 * 
 * @author EHP
 * 
 */
public class CommonOutputValidatorTest {

    @Test
    public void testSuccess() throws Exception {
        CommonOutputType commonOutput = new CommonOutputType();
        commonOutput.setInputReference("test");
        commonOutput.setNIPReference("test");
        commonOutput.setOutputReference("test");
        CommonOutputValidator.validate(commonOutput);
    }

    @Test
    public void testFailInputReference() throws Exception {
        CommonOutputType commonOutput = new CommonOutputType();
        commonOutput.setNIPReference("test");
        commonOutput.setOutputReference("test");
        try {
            CommonOutputValidator.validate(commonOutput);
        } catch (ConnectorValidationException e) {
            Assert.assertEquals(1, e.getValidationErrors().size());
        }
    }

    @Test
    public void testFailNIPReference() throws Exception {
        CommonOutputType commonOutput = new CommonOutputType();
        commonOutput.setInputReference("test");
        commonOutput.setOutputReference("test");
        try {
            CommonOutputValidator.validate(commonOutput);
        } catch (ConnectorValidationException e) {
            Assert.assertEquals(1, e.getValidationErrors().size());
        }
    }

    @Test
    public void testFailOutputReference() throws Exception {
        CommonOutputType commonOutput = new CommonOutputType();
        commonOutput.setInputReference("test");
        commonOutput.setNIPReference("test");
        try {
            CommonOutputValidator.validate(commonOutput);
        } catch (ConnectorValidationException e) {
            Assert.assertEquals(1, e.getValidationErrors().size());
        }
    }

    @Test
    public void testFailMulti() throws Exception {
        CommonOutputType commonOutput = new CommonOutputType();
        try {
            CommonOutputValidator.validate(commonOutput);
        } catch (ConnectorValidationException e) {
            Assert.assertEquals(3, e.getValidationErrors().size());
        }
    }
}
