/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.mycarenetcommons.builders.impl;

import java.io.InputStream;
import java.util.UUID;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3._2005._05.xmlmime.Base64Binary;

import be.ehealth.business.mycarenetcommons.builders.util.BlobUtil;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.mycarenet.commons.core.v2.BlobType;
import be.fgov.ehealth.technicalconnector.signature.config.impl.ConfigurationModuleRegisterTransformers;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * Test for {@link BlobBuilder} ( token needs to be created in this test , so not possible to launch it without network or access to accept
 * environment )
 * 
 * @author EHP
 * 
 */
public class BlobUtilIntegrationTest {

    private static byte[] content;

    private static String encodingType;

    private static String id;

    private static String contentType;

    @BeforeClass
    public static void init() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.mycarenetcommons.test.properties", true);
        new ConfigurationModuleRegisterTransformers().init(null);

        ConfigFactory.getConfigValidator().getConfig().setProperty("mycarenet.testxadesbes.request.xadestype", "xades");
        ConfigFactory.getConfigValidator().getConfig().setProperty("mycarenet.testxadest.request.xadestype", "xadest");
        ConfigFactory.getConfigValidator().getConfig().setProperty("mycarenet.badXadesType.request.xadestype", "unknown");
        ConfigFactory.getConfigValidator().getConfig().setProperty("mycarenet.default.request.xadestype", "xades");

        InputStream xmlFile = ConnectorIOUtils.getResourceAsStream("/examples/PostConsultationListeXml.xml");
        content = ConnectorIOUtils.compress(ConnectorIOUtils.getBytes(xmlFile));
        encodingType = "deflate";
        id = "_" + UUID.randomUUID().toString();
        contentType = "text/xml";
    }

    @Test
    public void testGenerateXadesDefault() throws Exception {
        BlobType blob = new BlobType();
        blob.setContentEncoding(encodingType);
        blob.setContentType(contentType);
        blob.setId(id);
        blob.setValue(content);

        Base64Binary response = BlobUtil.generateXades(blob);
        Assert.assertNotNull(response);
        Assert.assertNotNull(response.getValue());
    }

    @Test
    public void testGenerateXadesBes() throws Exception {
        BlobType blob = new BlobType();
        blob.setContentEncoding(encodingType);
        blob.setContentType(contentType);
        blob.setId(id);
        blob.setValue(content);

        Base64Binary response = BlobUtil.generateXades(blob, "testxadesbes");
        Assert.assertNotNull(response);
        Assert.assertNotNull(response.getValue());
    }

    @Test
    public void testGenerateXadesT() throws Exception {
        BlobType blob = new BlobType();
        blob.setContentEncoding(encodingType);
        blob.setContentType(contentType);
        blob.setId(id);
        blob.setValue(content);

        Base64Binary response = BlobUtil.generateXades(blob, "testxadest");
        Assert.assertNotNull(response);
        Assert.assertNotNull(response.getValue());
    }

    @Test(expected = TechnicalConnectorException.class)
    public void testBadXadesType() throws Exception {
        BlobType blob = new BlobType();
        blob.setContentEncoding(encodingType);
        blob.setContentType(contentType);
        blob.setId(id);
        blob.setValue(content);

        BlobUtil.generateXades(blob, "badXadesType");
        Assert.fail("The test should have failed");
    }
}
