/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarFileHandler
extends AbstractSOAPHandler {
    private static final String TIMINGS = "timings";
    private static final Logger LOG = LoggerFactory.getLogger(HarFileHandler.class);
    private DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final String MESSAGE_ENDPOINT_ADDRESS = "javax.xml.ws.service.endpoint.address";
    private JSONObject harJson;
    private Long start;
    private Long recieved;
    private Long split;
    private String outputdir = ConfigFactory.getConfigValidator().getProperty("connector.output.dir", System.getProperty("java.io.tmpdir"));
    private static Properties applicationProps = new Properties();

    @Override
    public boolean handleFault(SOAPMessageContext ctx) {
        Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound.booleanValue()) {
            return false;
        }
        this.handleMessage(ctx);
        return true;
    }

    @Override
    public boolean handleInbound(SOAPMessageContext context) {
        this.setHandler();
        SOAPMessage msg = context.getMessage();
        try {
            String[] header;
            String soapenv = this.getEnvelope(msg);
            JSONObject response = new JSONObject();
            response.put((Object)"status", (Object)200);
            response.put((Object)"statusText", (Object)"OK");
            response.put((Object)"httpVersion", (Object)"HTTP/1.1");
            response.put((Object)"headers", (Object)this.handleHeaders(msg.getMimeHeaders()));
            response.put((Object)"cookies", (Object)new JSONArray());
            JSONObject content = new JSONObject();
            content.put((Object)"size", (Object)soapenv.getBytes().length);
            response.put((Object)"headersSize", (Object)-1);
            response.put((Object)"bodySize", (Object)-1);
            response.put((Object)"redirectURL", (Object)"");
            content.put((Object)"mimeType", (Object)"text/xml; charset=utf-8");
            if (msg.getMimeHeaders() != null && (header = msg.getMimeHeaders().getHeader("Content-Type")) != null && header.length > 0) {
                content.put((Object)"mimeType", (Object)header[0]);
            }
            content.put((Object)"text", (Object)soapenv);
            response.put((Object)"content", (Object)content);
            this.getEntry().put((Object)"response", (Object)response);
            ((Map)this.getEntry().get((Object)TIMINGS)).put("wait", this.recieved - this.split);
            long end = System.currentTimeMillis();
            ((Map)this.getEntry().get((Object)TIMINGS)).put("receive", end - this.recieved);
            this.getEntry().put((Object)"time", (Object)(end - this.start));
            this.saveHar();
        }
        catch (SOAPException e) {
            LOG.error("SOAPException", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IOException", (Throwable)e);
        }
        catch (TechnicalConnectorException e) {
            LOG.error("TechnicalConnectorException", (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        this.setHandler();
        SOAPMessage msg = context.getMessage();
        try {
            JSONObject request = new JSONObject();
            request.put((Object)"method", (Object)"POST");
            request.put((Object)"url", context.get((Object)MESSAGE_ENDPOINT_ADDRESS));
            request.put((Object)"httpVersion", (Object)"HTTP/1.1");
            request.put((Object)"headers", (Object)this.handleHeaders(msg.getMimeHeaders()));
            request.put((Object)"queryString", (Object)new JSONArray());
            request.put((Object)"cookies", (Object)new JSONArray());
            request.put((Object)"headersSize", (Object)-1);
            request.put((Object)"postData", (Object)this.getPostData(msg));
            request.put((Object)"time", (Object)"1");
            request.put((Object)"bodySize", (Object)-1);
            this.split = System.currentTimeMillis();
            ((Map)this.getEntry().get((Object)TIMINGS)).put("send", this.split - this.start);
            this.getEntry().put((Object)"request", (Object)request);
        }
        catch (SOAPException e) {
            LOG.error("SOAPException", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IOException", (Throwable)e);
        }
        return true;
    }

    private void saveHar() throws FileNotFoundException, IOException, UnsupportedEncodingException, TechnicalConnectorException {
        String fileName = IdGeneratorFactory.getIdGenerator("uuid").generateId() + ".har";
        File file = new File(this.outputdir, fileName);
        LOG.info("Writing har file on location:" + file.getPath());
        FileWriter fw = new FileWriter(file);
        this.harJson.writeJSONString((Writer)fw);
    }

    private JSONObject getPostData(SOAPMessage msg) throws SOAPException, IOException {
        JSONObject postData = new JSONObject();
        postData.put((Object)"mimeType", (Object)"multipart/form-data");
        postData.put((Object)"params", (Object)new JSONArray());
        postData.put((Object)"text", (Object)this.getEnvelope(msg));
        return postData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEnvelope(SOAPMessage message) throws SOAPException, IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)stream);
            if (stream.size() < 1232896) {
                String string = stream.toString(Charset.UTF_8.getName());
                return string;
            }
            String string = "message to large to log";
            return string;
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)stream);
        }
    }

    private JSONArray handleHeaders(MimeHeaders headers) throws IOException {
        JSONArray response = new JSONArray();
        if (headers != null) {
            Iterator headersIterator = headers.getAllHeaders();
            while (headersIterator.hasNext()) {
                MimeHeader mimheader = (MimeHeader)headersIterator.next();
                JSONObject header = new JSONObject();
                header.put((Object)"name", (Object)mimheader.getName());
                header.put((Object)"value", (Object)mimheader.getValue());
                response.add((Object)header);
            }
        }
        return response;
    }

    private void prepareHarFile() {
        LOG.info("Start creating har file");
        JSONObject creator = new JSONObject();
        creator.put((Object)"name", (Object)applicationProps.getProperty("application.name", "UNKOWN"));
        creator.put((Object)"version", (Object)applicationProps.getProperty("application.version", "UNKOWN"));
        JSONArray entries = new JSONArray();
        JSONObject entry = new JSONObject();
        entry.put((Object)"startedDateTime", (Object)this.dateFormatter.format(new Date()));
        entry.put((Object)"cache", (Object)new JSONArray());
        entry.put((Object)TIMINGS, (Object)new JSONObject());
        entries.add((Object)entry);
        JSONObject log = new JSONObject();
        log.put((Object)"version", (Object)"1.2");
        log.put((Object)"creator", (Object)creator);
        log.put((Object)"entries", (Object)entries);
        this.harJson = new JSONObject();
        this.harJson.put((Object)"log", (Object)log);
    }

    private JSONObject getEntry() {
        JSONObject log = (JSONObject)this.harJson.get((Object)"log");
        JSONArray entries = (JSONArray)log.get((Object)"entries");
        return (JSONObject)entries.get(0);
    }

    private void setHandler() {
        if (this.start == null) {
            this.start = System.currentTimeMillis();
        } else {
            this.recieved = System.currentTimeMillis();
        }
        if (this.harJson == null) {
            this.prepareHarFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            is = ConnectorIOUtils.getResourceAsStream("/application.properties");
            applicationProps.load(is);
        }
        catch (TechnicalConnectorException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)is);
        }
    }
}

