/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public final class DateUtils {
    private DateUtils() {
        throw new UnsupportedOperationException();
    }

    public static DateTime parseDateTime(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return ISODateTimeFormat.dateTimeParser().parseDateTime(text);
    }

    public static String printDateTime(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return ISODateTimeFormat.dateTime().print((ReadableInstant)dateTime);
    }

    public static DateTime parseTime(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return ISODateTimeFormat.timeParser().parseDateTime(text);
    }

    public static String printTime(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return ISODateTimeFormat.time().print((ReadableInstant)dateTime);
    }

    public static DateTime parseDate(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return ISODateTimeFormat.dateParser().parseDateTime(text);
    }

    public static String printDate(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return ISODateTimeFormat.date().print((ReadableInstant)dateTime);
    }

    public static DateTime convert(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return new DateTime((Object)cal);
    }

    public static DateTime convert(Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime((Object)date);
    }
}

