﻿using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.handler;
using be.ehealth.technicalconnector.ws.domain;
using java.util;
using org.w3c.dom;

#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.ehealth.technicalconnector.ws
{
    using System;
    using System.IO;
    using System.Text;

    using be.ehealth.technicalconnector.config;
    using be.ehealth.technicalconnector.service.sts.security;
    using be.ehealth.technicalconnector.utils;
    using be.ehealth.technicalconnector.utils.net;
    using be.ehealth.technicalconnector.ws;

    using NUnit.Framework;

    /**
     * The Class GenericWsUnsecuredITTest.
     */
    [TestFixture]
    class GenericWSUnsecuredITTest
    {
        #region Methods
	    private static Properties config;
	
	    [SetUp]
	    public static void init() {
	    	ConfigFactory.setConfigLocation(".\\be.ehealth.technicalconnector.properties");
	        config = TestPropertiesLoader.getProperties(".\\be.ehealth.technicalconnector.test.properties",".net");
	    }
	
	    /**
	     * Use the Generic Certificate Secured Web Service method to call Codage's encode operation
	     * 
	     * This test includes the following main steps: 1. Set the URL to the web service end-point 2. Get the payload 3. Send the message
	     */
	    [Test]
	    public void testSendUnsecured() {
	        GenericRequest request = new GenericRequest();
	        request.setPayload(getPayload());
	        request.setEndpoint(config.getProperty("test.unsecured.endpoint"));
	        request.setDefaultHandlerChain();
	        request.getSecurityHandlerChain().add(new SoapActionHandler());
	        
	        GenericWsSender sender = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender();
	        String result = null;
	        try {
	            result = sender.send(request).asString();
	        } catch (javax.xml.soap.SOAPException e) {
	            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, e, e.getMessage());
	        }
	        
	        // check if something has been received
	        Assert.NotNull(result);
	    }
	
	    /**
	     * Use the Generic Certificate Secured Web Service method to call Codage's encode operation
	     * 
	     * This test includes the following main steps: 1. Set the URL to the web service end-point 2. Get the payload 3. Send the message
	     * 
	     */
	    [Test]
	    public void testSendUnsecuredDOM() {
	        GenericRequest request = new GenericRequest();
	        request.setPayload(getPayload());
	        request.setEndpoint(config.getProperty("test.unsecured.endpoint"));
	        request.setDefaultHandlerChain();
	        request.getSecurityHandlerChain().add(new SoapActionHandler());
	        
	        GenericWsSender sender = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender();
	        Node result = null;
	        try {
	            result = sender.send(request).asNode();
	        } catch (javax.xml.soap.SOAPException e) {
	            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, e, e.getMessage());
	        }
	        
	        // check if something has been received
	        Assert.NotNull(result);
	    }
	
	    /**
	     * Helper method for testSendCertSecured Read out the request from XML file
	     */
	    private String getPayload() {
	        // get the file where the XML request is stored
	        String location = config.getProperty("test.xml.etk.request");
	        // read out the XML request to string
	        return ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream(location));
	    }

        #endregion Methods
    }
}