package be.ehealth.businessconnector.test.consultrnv2.session.support;

import be.ehealth.businessconnector.test.testcommons.utils.FileTestUtils;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class RequestTransformer {

    private static final String VALID_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWCYZ";

    private static final int VARIABLE_NAME_MAX_INDEX = VALID_CHARS.length();

    private static final int VARIABLE_NAME_LENGTH = 13;

    public <T> T transform(String fileLocation, Class<T> clazz) throws Exception {
        Map<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("issueInstant", DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'+02:00'").print(new DateTime()));
        velocityContext.put("requestId", IdGeneratorFactory.getIdGenerator("uuid").generateId());
        velocityContext.put("currentDate", DateTimeFormat.forPattern("yyyy-MM-dd").print(new DateTime()));
        velocityContext.put("generatedChars1", RandomStringUtils.randomAlphabetic(10).toLowerCase());
        velocityContext.put("generatedChars2", RandomStringUtils.randomAlphabetic(10).toLowerCase());
        velocityContext.put("variableName", generateVariableName());
        return FileTestUtils.toObject(velocityContext, fileLocation, clazz);
    }

    private String generateVariableName() {
        String variableName = StringUtils.EMPTY;
        Random random = new Random();
        for (int i=0; i<VARIABLE_NAME_LENGTH; ++i) {
            int index = Math.abs(random.nextInt() % VARIABLE_NAME_MAX_INDEX);
            variableName += VALID_CHARS.charAt(index);
        }
        return variableName;
    }

}
