/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.distributedkeys;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.fgov.ehealth.technicalconnector.distributedkeys.DistributedSignerProxy;
import be.fgov.ehealth.technicalconnector.distributedkeys.jca.DistributedKeyLoadStoreParam;
import be.fgov.ehealth.technicalconnector.distributedkeys.jca.DistributedKeyProvider;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributedKeyStoreRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, KeyStore> distributedKeyStores = new HashMap<String, KeyStore>();
    private static final Logger LOG = LoggerFactory.getLogger(DistributedKeyStoreRegistry.class);

    private DistributedKeyStoreRegistry() {
    }

    public static DistributedKeyStoreRegistry getInstance() {
        return DistributedKeyStoreRegistrySingleTon.INSTANCE.getDistributedKeyStoreRegistry();
    }

    public KeyStore createDistributedKeyStore(String key, DistributedSignerProxy proxy) throws TechnicalConnectorException {
        try {
            if (this.distributedKeyStores.containsKey(key)) {
                LOG.info("Key [" + key + "] already in cache. Returning cached one.");
                return this.distributedKeyStores.get(key);
            }
            KeyStore store = KeyStore.getInstance("DistributedKeyProvider");
            Validate.notNull((Object)store);
            DistributedKeyLoadStoreParam param = new DistributedKeyLoadStoreParam(proxy);
            store.load(param);
            this.distributedKeyStores.put(key, store);
            return store;
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (KeyStoreException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (NoSuchAlgorithmException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (CertificateException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public Map<String, KeyStore> getDistributedKeyStores() {
        return this.distributedKeyStores;
    }

    public void flushCache() {
        this.distributedKeyStores.clear();
    }

    static {
        Security.addProvider(new DistributedKeyProvider());
    }

    private static enum DistributedKeyStoreRegistrySingleTon {
        INSTANCE;

        private DistributedKeyStoreRegistry manager = new DistributedKeyStoreRegistry();

        public DistributedKeyStoreRegistry getDistributedKeyStoreRegistry() {
            return this.manager;
        }
    }
}

