/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributes;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPData;
import be.fgov.ehealth.etee.crypto.utils.Iterables;
import be.fgov.ehealth.etee.crypto.utils.Streams;
import java.io.Closeable;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.esf.ESFAttributes;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPUtil;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignerInfoAttributesReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignerInfoAttributesReceiver.class);
    private final DigestCalculatorProvider digestCalculatorProvider = new BcDigestCalculatorProvider();

    SignerInfoAttributesReceiver() {
    }

    SignerInfoAttributes parse(SignerInformation signerInfo) throws TSPException {
        RevocationValues revocationValues;
        AttributeTable unsignedAttributes;
        SignerInfoAttributes attributes = new SignerInfoAttributes();
        AttributeTable signedAttributes = signerInfo.getSignedAttributes();
        if (signedAttributes != null) {
            attributes.setSigningTime(this.extractSigningTime(signedAttributes));
        }
        if ((unsignedAttributes = signerInfo.getUnsignedAttributes()) != null && (revocationValues = this.extractRevocationValues(unsignedAttributes)) != null) {
            attributes.getOcspResponses().addAll(this.extractEmbeddedOCSPResponses(revocationValues));
            attributes.getCrls().addAll(this.extractEmbeddedCRLs(revocationValues));
        }
        Collection signatureTimestamps = TSPUtil.getSignatureTimestamps((SignerInformation)signerInfo, (DigestCalculatorProvider)this.digestCalculatorProvider);
        for (Object i : signatureTimestamps) {
            if (i instanceof TimeStampToken) {
                attributes.getSignatureTimestamps().add((TimeStampToken)i);
                continue;
            }
            LOGGER.warn("Ignoring unexpected timestamp token: " + i.getClass().getName());
        }
        return attributes;
    }

    Date extractSigningTime(AttributeTable signedAttributes) {
        Attribute attribute = signedAttributes.get(PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        if (attribute != null) {
            ASN1Set asn1Set = attribute.getAttrValues();
            return Time.getInstance((Object)asn1Set.getObjectAt(0).toASN1Primitive()).getDate();
        }
        return null;
    }

    RevocationValues extractRevocationValues(AttributeTable unsignedAttributes) {
        Attribute attribute = unsignedAttributes.get(ESFAttributes.revocationValues);
        if (attribute != null) {
            ASN1Set attrValues = attribute.getAttrValues();
            ASN1Encodable derEncodable = attrValues.getObjectAt(0);
            return RevocationValues.getInstance((Object)derEncodable);
        }
        return null;
    }

    List<BasicOCSPResp> extractEmbeddedOCSPResponses(RevocationValues revocationValues) {
        ArrayList<BasicOCSPResp> l = new ArrayList<BasicOCSPResp>();
        if (revocationValues.getOcspVals() == null) {
            return l;
        }
        for (BasicOCSPResponse response : revocationValues.getOcspVals()) {
            l.add(new BasicOCSPResp(response));
        }
        return l;
    }

    List<CertificateList> extractEmbeddedCRLs(RevocationValues revocationValues) {
        ArrayList<CertificateList> l = new ArrayList<CertificateList>();
        if (revocationValues.getCrlVals() == null) {
            return l;
        }
        Collections.addAll(l, revocationValues.getCrlVals());
        return l;
    }

    TimeStampToken readTimeStampToken(ASN1Primitive derEncodedTimeStamp) throws TSPException, IOException {
        ContentInfo contentInfo = ContentInfo.getInstance((Object)derEncodedTimeStamp);
        return new TimeStampToken(contentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ASN1Primitive readASN1Data(byte[] data) throws IOException {
        ASN1Primitive aSN1Primitive;
        ASN1InputStream stream = null;
        try {
            stream = new ASN1InputStream(data);
            aSN1Primitive = stream.readObject();
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(stream);
            throw throwable;
        }
        Streams.closeQuietly((Closeable)stream);
        return aSN1Primitive;
    }

    Map<ASN1ObjectIdentifier, ASN1Encodable> getUnsignedAttributesMap(SignerInformation signerInformation) {
        AttributeTable unsignedAttributeTable = signerInformation.getUnsignedAttributes();
        return unsignedAttributeTable != null ? unsignedAttributeTable.toHashtable() : new Hashtable();
    }

    SignerInformationStore addRevocationValues(SignerInformation signerInformation, RevocationValues revocationValues) {
        Map<ASN1ObjectIdentifier, ASN1Encodable> unsignedAttributeMap = this.getUnsignedAttributesMap(signerInformation);
        unsignedAttributeMap.put(PKCSObjectIdentifiers.id_aa_ets_revocationValues, (ASN1Encodable)new Attribute(PKCSObjectIdentifiers.id_aa_ets_revocationValues, (ASN1Set)new DERSet((ASN1Encodable)revocationValues)));
        SignerInformation newSignerInformation = this.replaceUnsignedAttributes(signerInformation, unsignedAttributeMap);
        return new SignerInformationStore(Iterables.newList(newSignerInformation));
    }

    SignerInformationStore addTimeStamp(SignerInformation signerInformation, ASN1Primitive derEncodedTimeStamp) {
        Map<ASN1ObjectIdentifier, ASN1Encodable> unsignedAttributeMap = this.getUnsignedAttributesMap(signerInformation);
        DERSet derSet = new DERSet((ASN1Encodable)derEncodedTimeStamp);
        unsignedAttributeMap.put(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Encodable)new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)derSet));
        SignerInformation newSignerInformation = this.replaceUnsignedAttributes(signerInformation, unsignedAttributeMap);
        return new SignerInformationStore(Iterables.newList(newSignerInformation));
    }

    SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, Map<ASN1ObjectIdentifier, ASN1Encodable> unsignedAttributeMap) {
        AttributeTable unsignedAttributeTable = new SimpleAttributeTableGenerator(new AttributeTable((Hashtable)unsignedAttributeMap)).getAttributes(null);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributeTable);
    }

    RevocationValues buildRevocationValues(OCSPData ocspData) throws IOException, CRLException {
        BasicOCSPResponse[] ocspVals = new BasicOCSPResponse[]{BasicOCSPResponse.getInstance((Object)this.readASN1Data(ocspData.getOcspResponse()))};
        CertificateList[] crlVals = new CertificateList[ocspData.getCrls().size()];
        int i = 0;
        for (X509CRL crl : ocspData.getCrls()) {
            crlVals[i++] = CertificateList.getInstance((Object)this.readASN1Data(crl.getEncoded()));
        }
        return new RevocationValues(crlVals, ocspVals, null);
    }
}

