/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.genins.service;

import java.io.InputStream;
import java.net.URL;

import javax.xml.XMLConstants;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

import be.ehealth.businessconnector.genins.service.ServiceFactory;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;


/**
 * Test for the Service factory
 * 
 * @author EHP
 * 
 */
public class ServiceFactoryTest {

    @Test
    public void testXSDPresent() throws Exception {
        validateSchemaFiles(ServiceFactory.GENINS_XSD);
    }

    public void validateSchemaFiles(String[] schemaFiles) throws Exception {
        Source[] sources = new Source[]{};
        for (String xsd : schemaFiles) {
            InputStream in = ServiceFactory.class.getResourceAsStream(xsd);
            Assert.assertNotNull(in);
            Assert.assertNotNull("Could not find file:" + xsd, in);
            Source source = new StreamSource(in);
            sources = (Source[]) ArrayUtils.add(sources, source);
        }

        SchemaFactory schemaFactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        if (sources.length == 1) {
            URL schemaurl = SchemaValidatorHandler.class.getResource(schemaFiles[0]);
            schemaFactory.newSchema(schemaurl);
        } else {
            schemaFactory.newSchema(sources);
        }
    }
}
