/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.encrypt.CmsEncrypter;
import be.fgov.ehealth.etee.crypto.encrypt.DataSealer;
import be.fgov.ehealth.etee.crypto.encrypt.DataSealerException;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionToken;
import be.fgov.ehealth.etee.crypto.encrypt.MessageSigner;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPException;
import be.fgov.ehealth.etee.crypto.policies.EncryptionCredential;
import be.fgov.ehealth.etee.crypto.utils.Streams;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TripleWrapper
implements DataSealer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleWrapper.class);
    private final CmsEncrypter cmsEncryptor;
    private final MessageSigner messageSigner;

    TripleWrapper(CmsEncrypter cmsEncryptor, MessageSigner messageSigner) {
        this.cmsEncryptor = cmsEncryptor;
        this.messageSigner = messageSigner;
    }

    @Override
    public byte[] seal(byte[] dataToSeal, EncryptionCredential ... encryptionKeys) throws DataSealerException {
        try {
            byte[] innerSignedData = this.messageSigner.signInnerData(dataToSeal);
            LOGGER.debug("Creating EnvelopedData...");
            byte[] encryptedData = this.cmsEncryptor.encryptData(innerSignedData, encryptionKeys);
            return this.messageSigner.signOuterData(encryptedData);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.buildDataSealerException("Algorithm not available.", e);
        }
        catch (CertificateException e) {
            throw this.buildDataSealerException("Certificates could not be added.", e);
        }
        catch (OCSPException e) {
            throw this.buildDataSealerException("RevocationValues could not be generated.", e);
        }
        catch (Exception e) {
            throw this.buildDataSealerException("Data could not be sealed.", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void seal(InputStream dataToSeal, OutputStream sealedData, EncryptionCredential ... encryptionKeys) throws DataSealerException {
        OutputStream dataToBeSignedStream = null;
        OutputStream dataToEncrypt = null;
        OutputStream dataToWrap = null;
        try {
            dataToBeSignedStream = this.messageSigner.openOuterDataStream(sealedData);
            dataToEncrypt = this.cmsEncryptor.openDataToBeEncryptedStream(dataToBeSignedStream, encryptionKeys);
            dataToWrap = this.messageSigner.openInnerDataStream(dataToEncrypt);
            Streams.copy(dataToSeal, dataToWrap);
        }
        catch (CertificateException e) {
            try {
                throw this.buildDataSealerException("Certificates could not be added.", e);
                catch (OCSPException e2) {
                    throw this.buildDataSealerException("RevocationValues could not be generated.", e2);
                }
                catch (Exception e3) {
                    throw this.buildDataSealerException("Data could not be sealed.", e3);
                }
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(dataToEncrypt);
                Streams.closeQuietly(dataToBeSignedStream);
                throw throwable;
            }
        }
        Streams.closeQuietly(dataToEncrypt);
        Streams.closeQuietly(dataToBeSignedStream);
    }

    @Override
    @Deprecated
    public byte[] seal(EncryptionToken etk, byte[] dataToEncrypt) throws DataSealerException {
        return this.seal(dataToEncrypt, etk != null ? EncryptionCredential.create(etk.getCertificate()) : null);
    }

    @Override
    @Deprecated
    public byte[] seal(Set<EncryptionToken> etks, byte[] dataToEncrypt) throws DataSealerException {
        return this.seal(dataToEncrypt, this.buildEncryptionCredentials(etks));
    }

    @Override
    @Deprecated
    public byte[] seal(EncryptionToken etk, byte[] dataToSeal, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        HashSet<EncryptionCredential> keys = new HashSet<EncryptionCredential>();
        if (etk != null) {
            keys.add(EncryptionCredential.create(etk.getCertificate()));
        }
        if (kek != null) {
            keys.add(EncryptionCredential.create(kek, base64encodeKekId));
        }
        return this.seal(dataToSeal, keys);
    }

    @Override
    @Deprecated
    public byte[] seal(Set<EncryptionToken> etks, byte[] dataToSeal, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        Set<EncryptionCredential> keys = this.buildEncryptionCredentials(etks);
        if (kek != null) {
            keys.add(EncryptionCredential.create(kek, base64encodeKekId));
        }
        return this.seal(dataToSeal, keys);
    }

    @Override
    @Deprecated
    public byte[] seal(byte[] dataToSeal, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        return this.seal(dataToSeal, kek != null ? EncryptionCredential.create(kek, base64encodeKekId) : null);
    }

    @Override
    @Deprecated
    public void seal(EncryptionToken etk, InputStream dataToSeal, OutputStream sealedData) throws DataSealerException {
        this.seal(dataToSeal, sealedData, etk != null ? EncryptionCredential.create(etk.getCertificate()) : null);
    }

    @Override
    @Deprecated
    public void seal(Set<EncryptionToken> etks, InputStream dataToSeal, OutputStream sealedData) throws DataSealerException {
        this.seal(dataToSeal, sealedData, this.buildEncryptionCredentials(etks));
    }

    @Override
    @Deprecated
    public void seal(EncryptionToken etk, InputStream dataToSeal, OutputStream sealedData, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        HashSet<EncryptionCredential> keys = new HashSet<EncryptionCredential>();
        if (etk != null) {
            keys.add(EncryptionCredential.create(etk.getCertificate()));
        }
        if (kek != null) {
            keys.add(EncryptionCredential.create(kek, base64encodeKekId));
        }
        this.seal(dataToSeal, sealedData, keys);
    }

    @Override
    @Deprecated
    public void seal(Set<EncryptionToken> etks, InputStream dataToSeal, OutputStream sealedData, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        Set<EncryptionCredential> keys = this.buildEncryptionCredentials(etks);
        if (kek != null) {
            keys.add(EncryptionCredential.create(kek, base64encodeKekId));
        }
        this.seal(dataToSeal, sealedData, keys);
    }

    @Override
    @Deprecated
    public void seal(InputStream dataToSeal, OutputStream sealedData, SecretKey kek, String base64encodeKekId) throws DataSealerException {
        this.seal(dataToSeal, sealedData, kek != null ? EncryptionCredential.create(kek, base64encodeKekId) : null);
    }

    private DataSealerException buildDataSealerException(String msg, Exception cause) {
        LOGGER.error(msg, (Throwable)cause);
        return new DataSealerException(msg, cause);
    }

    private Set<EncryptionCredential> buildEncryptionCredentials(Set<EncryptionToken> etks) {
        HashSet<EncryptionCredential> keys = new HashSet<EncryptionCredential>();
        if (etks == null) {
            return keys;
        }
        for (EncryptionToken etk : etks) {
            keys.add(EncryptionCredential.create(etk.getCertificate()));
        }
        return keys;
    }

    private byte[] seal(byte[] dataToSeal, Set<EncryptionCredential> keys) throws DataSealerException {
        return this.seal(dataToSeal, keys.toArray(new EncryptionCredential[keys.size()]));
    }

    private void seal(InputStream dataToSeal, OutputStream sealedData, Set<EncryptionCredential> keys) throws DataSealerException {
        this.seal(dataToSeal, sealedData, keys.toArray(new EncryptionCredential[keys.size()]));
    }
}

