/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.etee.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.service.etee.domain.EncryptionToken;
import be.ehealth.technicalconnector.service.etee.impl.AbstractCrypto;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEndToEndCrypto
extends AbstractCrypto {
    private static Configuration config = ConfigFactory.getConfigValidator();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEndToEndCrypto.class);
    public static final String PROP_DUMP_MESSAGES = "be.ehealth.technicalconnector.service.etee.cryptoimpl.dump_messages";
    public static final String PROP_DUMP_FIRST_CHARS = "be.ehealth.technicalconnector.service.etee.cryptoimpl.dump_first_chars";

    @Override
    public byte[] seal(EncryptionToken paramEncryptionToken, byte[] paramArrayOfByte) throws TechnicalConnectorException {
        HashSet<EncryptionToken> etkSet = new HashSet<EncryptionToken>();
        etkSet.add(paramEncryptionToken);
        return this.seal(etkSet, paramArrayOfByte);
    }

    @Override
    public byte[] seal(Set<EncryptionToken> paramEncryptionTokenSet, byte[] paramArrayOfByte) throws TechnicalConnectorException {
        return this.seal(paramEncryptionTokenSet, paramArrayOfByte, null, null);
    }

    @Override
    public byte[] seal(byte[] paramArrayOfByte, SecretKey secretKey, String base64encodedSymKekId) throws TechnicalConnectorException {
        return this.seal(null, paramArrayOfByte, secretKey, base64encodedSymKekId);
    }

    @Override
    public byte[] seal(Set<EncryptionToken> paramEncryptionTokenSet, byte[] content, SecretKey secretKey, String base64encodedSymKekId) throws TechnicalConnectorException {
        return this.seal(Crypto.SigningPolicySelector.WITH_NON_REPUDIATION, paramEncryptionTokenSet, new KeyResult(secretKey, base64encodedSymKekId), content);
    }

    @Override
    public byte[] seal(Crypto.SigningPolicySelector type, KeyResult symmKey, byte[] content) throws TechnicalConnectorException {
        return this.seal(type, null, symmKey, content);
    }

    @Override
    public byte[] seal(Crypto.SigningPolicySelector type, EncryptionToken encryptionToken, byte[] content) throws TechnicalConnectorException {
        HashSet<EncryptionToken> etkSet = new HashSet<EncryptionToken>();
        etkSet.add(encryptionToken);
        return this.seal(type, etkSet, content);
    }

    @Override
    public byte[] seal(Crypto.SigningPolicySelector type, Set<EncryptionToken> paramEncryptionTokenSet, byte[] content) throws TechnicalConnectorException {
        return this.seal(type, paramEncryptionTokenSet, null, content);
    }

    @Override
    public byte[] unseal(byte[] protectedMessage) throws TechnicalConnectorException {
        byte[] result = this.unseal(Crypto.SigningPolicySelector.WITH_NON_REPUDIATION, protectedMessage).getContentAsByte();
        this.dumpMessage(result, "Message unsealed");
        return result;
    }

    @Override
    public byte[] unsealForUnknown(SecretKey key, byte[] protectedMessage) throws TechnicalConnectorException {
        byte[] result = this.unseal(Crypto.SigningPolicySelector.WITH_NON_REPUDIATION, new KeyResult(key, "dummy"), protectedMessage).getContentAsByte();
        this.dumpMessage(result, "Message unsealed");
        return result;
    }

    protected void dumpMessage(byte[] paramArrayOfByte, String msg) {
        if (Boolean.TRUE.equals(config.getBooleanProperty(PROP_DUMP_MESSAGES, Boolean.FALSE))) {
            int maxNumberOfBytesToLog = config.getIntegerProperty(PROP_DUMP_FIRST_CHARS, 50);
            String stringToLog = paramArrayOfByte.length < maxNumberOfBytesToLog ? new String(paramArrayOfByte) : new String(ArrayUtils.subarray((byte[])paramArrayOfByte, (int)0, (int)(maxNumberOfBytesToLog - 1)));
            LOG.debug("{}: {}", (Object)msg, (Object)stringToLog);
        }
    }
}

