/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.google.common.base.Strings;
import java.util.regex.PatternSyntaxException;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.NottableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexStringMatcher
extends BodyMatcher<NottableString> {
    private static final Logger logger = LoggerFactory.getLogger(RegexStringMatcher.class);
    private final NottableString matcher;

    public RegexStringMatcher(String matcher) {
        this.matcher = NottableString.string(matcher);
    }

    public RegexStringMatcher(NottableString matcher) {
        this.matcher = matcher;
    }

    public static boolean matches(NottableString matcher, NottableString matched, boolean ignoreCase) {
        return matcher.isNot() != (matched.isNot() != RegexStringMatcher.matches(matcher.getValue(), matched.getValue(), ignoreCase));
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        boolean result = false;
        if (Strings.isNullOrEmpty((String)matcher)) {
            result = true;
        } else if (matched != null) {
            if (matched.equals(matcher)) {
                result = true;
            }
            if (!result) {
                try {
                    if (matched.matches(matcher)) {
                        result = true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    logger.trace("Error while matching regex [" + matcher + "] for string [" + matched + "] " + pse.getMessage());
                }
                try {
                    if (matcher.matches(matched)) {
                        result = true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    logger.trace("Error while matching regex [" + matched + "] for string [" + matcher + "] " + pse.getMessage());
                }
                if (!result && ignoreCase) {
                    if (matched.equalsIgnoreCase(matcher)) {
                        result = true;
                    }
                    try {
                        if (matched.toLowerCase().matches(matcher.toLowerCase())) {
                            result = true;
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        logger.trace("Error while matching regex [" + matcher.toLowerCase() + "] for string [" + matched.toLowerCase() + "] " + pse.getMessage());
                    }
                    try {
                        if (matcher.toLowerCase().matches(matched.toLowerCase())) {
                            result = true;
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        logger.trace("Error while matching regex [" + matched.toLowerCase() + "] for string [" + matcher.toLowerCase() + "] " + pse.getMessage());
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean matches(String matched) {
        return this.matches(NottableString.string(matched));
    }

    @Override
    public boolean matches(NottableString matched) {
        boolean result = false;
        if (RegexStringMatcher.matches(this.matcher.getValue(), matched.getValue(), false)) {
            result = true;
        }
        if (!result) {
            logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return (this.matcher.isNot() || matched.isNot()) != this.reverseResultIfNot(result);
    }
}

