/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.domain.Duration;
import be.ehealth.technicalconnector.config.impl.ConfigurationImpl;
import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigValidatorImpl
implements ConfigValidator {
    public static final String PROP_VALIDATOR_ACTIVATOR = "be.ehealth.technicalconnector.config.impl.ConfigValidatorImpl.throwErrorOnInvalidconfig";
    private static final Boolean PROP_VALIDATOR_ACTIVATOR_DEFAULT = Boolean.TRUE;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigValidatorImpl.class);
    private Boolean valid;
    private Object[] unfoundProps = new Object[0];
    private List<String> expectedProps = new ArrayList<String>();
    private Configuration config;

    public ConfigValidatorImpl(List<String> expectedProps) {
        this(expectedProps, null);
    }

    public ConfigValidatorImpl(List<String> expectedProps, Configuration config) {
        if (expectedProps != null) {
            this.expectedProps.addAll(expectedProps);
        }
        this.config = config;
    }

    private void init() throws TechnicalConnectorException {
        if (this.config == null) {
            this.config = ConfigurationImpl.getInstance();
        }
        if (this.valid == null) {
            this.valid = this.validate();
        }
    }

    @Override
    public final Configuration getConfig() throws TechnicalConnectorException {
        this.init();
        if (!Boolean.TRUE.equals(this.valid)) {
            StringBuilder sb = new StringBuilder("Could not find properties. ");
            for (Object propObj : this.unfoundProps) {
                sb.append("[" + propObj.toString() + "]");
            }
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.INVALID_CONFIG, sb.toString());
        }
        return this.config;
    }

    private boolean validate() {
        this.unfoundProps = new Object[0];
        for (String prop : this.expectedProps) {
            boolean validProp = this.config.containsKey(prop);
            boolean validMatchProp = this.config.containsKey(prop + ".1");
            if (validProp || validMatchProp) {
                validProp = true;
            }
            if (validProp) continue;
            LOG.warn("Could not find property: {}", (Object)prop);
            this.unfoundProps = ArrayUtils.add((Object[])this.unfoundProps, (Object)prop);
        }
        return ArrayUtils.isEmpty((Object[])this.unfoundProps);
    }

    @Override
    public List<Object> getUnfoundPropertiesAfterValidation() throws TechnicalConnectorException {
        this.init();
        return Arrays.asList(this.unfoundProps);
    }

    @Override
    public final boolean isValid() throws TechnicalConnectorException {
        this.init();
        return this.valid;
    }

    @Override
    public final void invalidateCache() {
        this.config = null;
        this.valid = null;
        this.unfoundProps = new Object[0];
    }

    @Override
    public final String getProperty(String key, String defaultValue) {
        try {
            return this.getConfig().getProperty(key, defaultValue);
        }
        catch (TechnicalConnectorException e) {
            return (String)this.processException(e);
        }
    }

    private Object processException(Exception e) {
        if (Boolean.TRUE.equals(this.config.getBooleanProperty(PROP_VALIDATOR_ACTIVATOR, PROP_VALIDATOR_ACTIVATOR_DEFAULT))) {
            LOG.error("No Valid config", (Throwable)e);
            throw new ConfigurationException("No Valid config. Reason[" + e.getMessage() + "]");
        }
        LOG.warn("No Valid config. Reason[{}]", (Object)e.getMessage());
        return null;
    }

    @Override
    public final Long getLongProperty(String key, Long defaultValue) {
        try {
            return this.getConfig().getLongProperty(key, defaultValue);
        }
        catch (TechnicalConnectorException e) {
            return (Long)this.processException(e);
        }
    }

    @Override
    public final Integer getIntegerProperty(String key, Integer defaultValue) {
        try {
            return this.getConfig().getIntegerProperty(key, defaultValue);
        }
        catch (TechnicalConnectorException e) {
            return (Integer)this.processException(e);
        }
    }

    @Override
    public final Boolean getBooleanProperty(String key, Boolean defaultValue) {
        try {
            return this.getConfig().getBooleanProperty(key, defaultValue);
        }
        catch (TechnicalConnectorException e) {
            return (Boolean)this.processException(e);
        }
    }

    @Override
    public Duration getDurationProperty(String key, Long defaultValue, TimeUnit defaultTimeUnit) {
        try {
            return this.getConfig().getDurationProperty(key, defaultValue, defaultTimeUnit);
        }
        catch (TechnicalConnectorException e) {
            return (Duration)this.processException(e);
        }
    }

    @Override
    public boolean hasDurationProperty(String key) {
        try {
            return this.getConfig().hasDurationProperty(key);
        }
        catch (TechnicalConnectorException e) {
            return (Boolean)this.processException(e);
        }
    }

    @Override
    public final String getProperty(String key) {
        try {
            return this.getConfig().getProperty(key);
        }
        catch (TechnicalConnectorException e) {
            return (String)this.processException(e);
        }
    }

    @Override
    public final boolean containsKey(String key) {
        try {
            return this.getConfig().containsKey(key);
        }
        catch (TechnicalConnectorException e) {
            this.processException(e);
            return false;
        }
    }

    @Override
    public final URL getURLProperty(String property) {
        try {
            return this.getConfig().getURLProperty(property);
        }
        catch (TechnicalConnectorException e) {
            return (URL)this.processException(e);
        }
    }

    @Override
    public final void setProperty(String key, String value) {
        try {
            this.getConfig().setProperty(key, value);
        }
        catch (TechnicalConnectorException e) {
            LOG.warn("No valid config. setProperty(" + key + ", value) didn't work!!!", (Throwable)e);
        }
    }

    @Override
    public final boolean hasProperty(String key) {
        try {
            return this.getConfig().hasProperty(key);
        }
        catch (TechnicalConnectorException e) {
            this.processException(e);
            return false;
        }
    }

    @Override
    public boolean hasMatchingProperty(String rootKey) {
        try {
            return this.getConfig().hasMatchingProperty(rootKey);
        }
        catch (TechnicalConnectorException e) {
            this.processException(e);
            return false;
        }
    }

    @Override
    public final List<String> getMatchingProperties(String rootKey) {
        try {
            return this.getConfig().getMatchingProperties(rootKey);
        }
        catch (TechnicalConnectorException e) {
            this.processException(e);
            return new ArrayList<String>();
        }
    }

    @Override
    public final void setConfigLocation(String location) throws TechnicalConnectorException {
        ConfigFactory.setConfigLocation(location);
        this.init();
        this.config.setConfigLocation(location);
    }

    @Override
    public final Configuration getCurrentConfig() {
        try {
            return this.getConfig().getCurrentConfig();
        }
        catch (TechnicalConnectorException e) {
            return (Configuration)this.processException(e);
        }
    }

    @Override
    public void invalidate() throws TechnicalConnectorException {
        this.getConfig().invalidate();
    }

    @Override
    public void reload() throws TechnicalConnectorException {
        this.getConfig().reload();
    }

    @Override
    public boolean isReloading() {
        try {
            return this.getConfig().isReloading();
        }
        catch (TechnicalConnectorException e) {
            return (Boolean)this.processException(e);
        }
    }
}

