/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehbox.v3.service;

import be.ehealth.businessconnector.ehbox.v3.exception.OoOPublicationException;
import be.ehealth.businessconnector.ehbox.v3.validator.EhboxReplyValidator;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.ServiceFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;

public class EhBoxServiceHelper {
    public static <T extends ResponseType> T callEhBoxService(SAMLToken token, GenericRequest service, String soapAction, Object request, Class<T> responseClass, SessionValidator sessValidator, EhboxReplyValidator replyValidator) throws ConnectorException {
        try {
            sessValidator.validateToken(token);
            service.setPayload(request);
            service.setSoapAction(soapAction);
            GenericResponse xmlResponse = ServiceFactory.getGenericWsSender().send(service);
            ResponseType response = (ResponseType)xmlResponse.asObject(responseClass);
            replyValidator.validateReplyStatus(response);
            return (T)response;
        }
        catch (Exception e) {
            if (e instanceof OoOPublicationException || e instanceof TechnicalConnectorException) {
                throw (ConnectorException)e;
            }
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

