/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.keydepot.impl;

import be.ehealth.technicalconnector.cache.Cache;
import be.ehealth.technicalconnector.cache.CacheFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.ServiceFactory;
import be.ehealth.technicalconnector.service.etee.domain.EncryptionToken;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManager;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotService;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.ehealth.technicalconnector.session.SessionServiceWithCache;
import be.ehealth.technicalconnector.utils.CertificateParser;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyDepotManagerImpl
implements KeyDepotManager,
SessionServiceWithCache {
    private static final Logger LOG = LoggerFactory.getLogger(KeyDepotManagerImpl.class);
    private KeyDepotService service;
    private Cache<X509Certificate, EncryptionToken> cache = CacheFactory.newInstance(CacheFactory.CacheType.MEMORY, "etkdepot-manager", CacheInformation.ExpiryType.NONE, null);

    private KeyDepotManagerImpl() {
        try {
            this.service = ServiceFactory.getKeyDepotService();
        }
        catch (TechnicalConnectorException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        Session.getInstance().registerSessionService(this);
    }

    public static KeyDepotManager getInstance() {
        return KeyDepotManagerImplSingleton.INSTANCE.getKeyDepotManager();
    }

    @Override
    public EncryptionToken getHolderOfKeyETK() throws TechnicalConnectorException {
        return this.getETK(KeyDepotManager.EncryptionTokenType.HOLDER_OF_KEY);
    }

    @Override
    public EncryptionToken getEncryptionETK() throws TechnicalConnectorException {
        return this.getETK(KeyDepotManager.EncryptionTokenType.ENCRYPTION);
    }

    @Override
    public EncryptionToken getETK(KeyDepotManager.EncryptionTokenType type) throws TechnicalConnectorException {
        SessionItem session = Session.getInstance().getSession();
        switch (type) {
            case ENCRYPTION: {
                return this.getEncryptionToken(session.getEncryptionCredential());
            }
            case HOLDER_OF_KEY: {
                return this.getEncryptionToken(session.getHolderOfKeyCredential());
            }
        }
        throw new IllegalArgumentException("Unsupported EncryptionTokenType.");
    }

    private EncryptionToken getEncryptionToken(Credential cred) throws TechnicalConnectorException {
        if (cred != null) {
            X509Certificate cert = cred.getCertificate();
            if (!this.cache.containsKey(cert)) {
                this.cache.put(cert, this.getEtkBasedOnX509(cert));
            }
            return this.cache.get(cert);
        }
        LOG.error(TechnicalConnectorExceptionValues.NO_VALID_SESSION_WITH_ENCRYPTION.getMessage());
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.NO_VALID_SESSION_WITH_ENCRYPTION, new Object[0]);
    }

    private EncryptionToken getEtkBasedOnX509(X509Certificate cert) throws TechnicalConnectorException {
        CertificateParser parser = new CertificateParser(cert);
        IdentifierType identifierType = parser.getIdentifier();
        String identifierValue = parser.getId();
        String application = parser.getApplication();
        if (identifierType == null || StringUtils.isEmpty((String)identifierValue) || !StringUtils.isNumeric((String)identifierValue)) {
            LOG.error(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND, new Object[0]);
        }
        try {
            return this.getEtk(identifierType, Long.parseLong(identifierValue), application);
        }
        catch (NumberFormatException e) {
            LOG.error(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public EncryptionToken getETK(IdentifierType identifierType, Long identifierValue, String application) throws TechnicalConnectorException {
        Set<EncryptionToken> etkSet = this.getEtkSet(identifierType, identifierValue, application);
        if (etkSet.size() != 1) {
            LOG.error(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND, new Object[0]);
        }
        return etkSet.iterator().next();
    }

    @Override
    public EncryptionToken getEtk(IdentifierType identifierType, Long identifierValue, String application) throws TechnicalConnectorException {
        return this.getETK(identifierType, identifierValue, application);
    }

    @Override
    public Set<EncryptionToken> getETKs(IdentifierType identifierType, Long identifierValue, String application) throws TechnicalConnectorException {
        String identifier = identifierType.formatIdentifierValue(identifierValue);
        HashSet<EncryptionToken> result = new HashSet<EncryptionToken>();
        result.addAll(this.service.getETKSet(identifierType, identifier, application));
        if (LOG.isDebugEnabled()) {
            StringBuilder keyBuilder = new StringBuilder();
            keyBuilder.append(identifierType).append("/").append(identifierValue).append("/").append(application).append(" size [").append(result.size()).append("] with serialnr [");
            String delim = "";
            for (EncryptionToken etk : result) {
                keyBuilder.append(delim).append(etk.getCertificate().getSerialNumber().toString(10));
                delim = ",";
            }
            keyBuilder.append("]");
            LOG.debug("Retrieved ETK from eHealth Key Depot Web Service: {}", (Object)keyBuilder.toString());
        }
        return result;
    }

    @Override
    public Set<EncryptionToken> getEtkSet(IdentifierType identifierType, Long identifierValue, String application) throws TechnicalConnectorException {
        return this.getETKs(identifierType, identifierValue, application);
    }

    @Override
    public void setKeyDepotService(KeyDepotService service) {
        this.service = service;
        this.flushCache();
    }

    @Override
    public void flushCache() {
        this.cache.clear();
    }

    private static enum KeyDepotManagerImplSingleton {
        INSTANCE;

        private transient KeyDepotManager instance = new KeyDepotManagerImpl();

        public KeyDepotManager getKeyDepotManager() {
            return this.instance;
        }
    }
}

