/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.testsupport.junit.rules;

import java.util.Map;
import java.util.Properties;
import org.junit.rules.ExternalResource;

public class SystemPropertiesRule
extends ExternalResource {
    private Properties originalProperties;
    private Properties props;

    public static PropertiesStep withProperty(String key, String value) {
        InnerSteps innerSteps = new InnerSteps();
        innerSteps.withProperty(key, value);
        return innerSteps;
    }

    public static SystemPropertiesRule build() {
        return new InnerSteps().build();
    }

    private SystemPropertiesRule(Properties props) {
        this.props = props;
    }

    protected void before() throws Throwable {
        this.originalProperties = System.getProperties();
        Properties properties = new Properties(this.originalProperties);
        properties.putAll((Map<?, ?>)this.props);
        System.setProperties(properties);
    }

    protected void after() {
        System.setProperties(this.originalProperties);
    }

    private static class InnerSteps
    implements PropertiesStep,
    BuildStep {
        private Properties props = new Properties();

        private InnerSteps() {
        }

        @Override
        public PropertiesStep withProperty(String key, String value) {
            this.props.put(key, value);
            return this;
        }

        @Override
        public SystemPropertiesRule build() {
            return new SystemPropertiesRule(this.props);
        }
    }

    public static interface BuildStep {
        public SystemPropertiesRule build();
    }

    public static interface PropertiesStep
    extends BuildStep {
        public PropertiesStep withProperty(String var1, String var2);
    }
}

