/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.ehbox.api.domain;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.businessconnector.ehbox.api.utils.QualityType;
import be.ehealth.technicalconnector.utils.IdentifierType;


/**
 * @author EH076
 */
public class AddresseeTest {
    
    //cornercases to test 
    // constructors 
    // getIdAsLong
    // 

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.api.domain.Addressee#Addressee(java.lang.String, be.ehealth.businessconnector.ehbox.api.utils.QualityType)}
     * .
     */
    @Test(expected = IllegalArgumentException.class)
    public void testAddresseeStringQualityType() {
        String str = null;
        QualityType type = null;
        Addressee newObject = new Addressee(str, type);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.api.domain.Addressee#Addressee(java.lang.String, be.ehealth.technicalconnector.utils.IdentifierType)}
     * .
     */
    @Test(expected = IllegalArgumentException.class)
    public void testAddresseeStringIdentifierType() {
        String str = null;
        IdentifierType type = null;
        Addressee newObject = new Addressee(type);
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.ehbox.api.domain.Addressee#Addressee(be.ehealth.technicalconnector.utils.IdentifierType)}.
     */
    @Test(expected = IllegalArgumentException.class)
    public void testAddresseeIdentifierType() {
        IdentifierType type = null;
        Addressee newObject = new Addressee(type);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.ehbox.api.domain.Addressee#toString()}.
     */
    @Test
    public void testToString() {
        Addressee addressee = new Addressee("1", IdentifierType.CBE);
        addressee.setApplicationId("applicationIdValue");
        addressee.setFirstName("firstnameValue");
        addressee.setLastName("lastNameValue");
        addressee.setOoOProcessed(true);
        addressee.setOrganizationName("organizationNameValue");
        addressee.setPersonInOrganisation("personInOrganisationValue");
        addressee.setQuality("qualityValue");
        String toStringValue = addressee.toString();
        
        Assert.assertTrue(toStringValue.indexOf("Addressee") != -1);
        Assert.assertTrue(toStringValue.indexOf("qualityValue") != -1);
        Assert.assertTrue(toStringValue.indexOf("organizationNameValue") != -1);
    }

    @Test
    public void testParseId() throws Exception {
        Addressee first = new Addressee("0", QualityType.APPLIED_PSYCH_BACHELOR_NIHII);
        Assert.assertEquals(0L, first.getIdAsLong());

        Addressee second = new Addressee("2", QualityType.AMBULANCE_RESCUER_NIHII);
        Assert.assertEquals(2L, second.getIdAsLong());
    }
    
    @Test(expected=NumberFormatException.class)
    public void testParseIdALL() throws Exception {
        Addressee third = new Addressee("ALL", QualityType.AMBULANCE_RESCUER_NIHII);
        third.getIdAsLong();
    }

   
}
