#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

/**
 * IntegrationTest for KeyDepotManager
 */
namespace be.ehealth.technicalconnector.service.keydepot
{
    using System;

    using be.ehealth.technicalconnector.config;
    using be.ehealth.technicalconnector.service.etee.domain;
    using be.ehealth.technicalconnector.service.keydepot.impl;
    using be.ehealth.technicalconnector.utils;
	using be.fgov.ehealth.technicalconnector.tests.utils.net;

    using java.lang;
    using java.util;

    using NUnit.Framework;

    [TestFixture]
    public class KeyDepotManagerIntegrationTest : be.ehealth.technicalconnector.session.AbstractServiceIntegrationTest
    {
        #region Fields

        private static KeyDepotManager manager = KeyDepotManagerFactory.getKeyDepotManager();

        #endregion Fields

        #region Methods

        [Test]
        public void getEtk()
        {
            string applicationName = TestPropertiesNetLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.myEtk.app");
            // The type of the identifier (linked to value)
            string type = TestPropertiesNetLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.myEtk.type");
            // the value linked to the typed
            string value = TestPropertiesNetLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.myEtk.value");

            EncryptionToken etk = manager.getEtk(IdentifierType.lookup(type,null,IdentifierType.ETKDEPOT), new Long(Long.parseLong(value)), applicationName);
            Assert.IsNotNull(etk);
        }

        [Test]
        public void multipleEtk()
        {
            Set etk = manager.getEtkSet(IdentifierType.CBE, new java.lang.Long(809394427L), null);
            Assert.IsNotNull(etk);
            Assert.IsTrue(etk.size()>1);
            Iterator it = etk.iterator();
            while (it.hasNext()) {
                EncryptionToken encryptionToken = (EncryptionToken) it.next();
                Console.WriteLine(encryptionToken.getEtk().getAuthenticationCertificate().getSubjectDN().toString());
            }
        }

        [Test]
        public void obtainEtkOfKgss()
        {
            EncryptionToken etk = manager.getEtk(IdentifierType.CBE, new java.lang.Long(809394427L), "KGSS");

            Assert.IsNotNull(etk);
        }

        #endregion Methods
    }
}