﻿/*
 * Copyright (c) eHealth
 */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using ikvm.extensions;
using NUnit.Framework;
using util = java.util;
using java.io;
using org.apache.xml.security.utils;
using be.ehealth.businessconnector.ehbox.api.domain;
using be.ehealth.businessconnector.ehbox.api.utils;
using be.ehealth.businessconnector.ehbox.v3.builders;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.ehbox.consultation.protocol.v3;
using be.fgov.ehealth.ehbox.core.v3;
using be.fgov.ehealth.ehbox.publication.protocol.v3;
using be.ehealth.businessconnector.ehbox.v3.session;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.ehboxv3.service
{
    [TestFixture]
    public class EhboxV3ServicePublicationIntegrationTest
    {

        private static bool isDoctorTest;
        /**
         * Properties file
         */
        private static String FILE_AS_DOC = ".\\be.ehealth.businessconnector.ehboxv3.test.properties";

        
        [SetUp]
        public void init(){
            try {
                java.util.Properties props = TestPropertiesLoader.getProperties(FILE_AS_DOC);
                SessionInitializer.init(FILE_AS_DOC, SupportedLanguages.NET.getAbbreviation());
                isDoctorTest = EhboxTestUtilities.isDoctorTest(props);
                Assume.That(isDoctorTest == true);
            } catch (TechnicalConnectorException e) {
                Assert.Fail("AbstractTherlinkTestWithSession.loadSession: error occured " + e.getMessage());
            }
            
        }

        [TearDown]
        public static void unloadSession() {
            be.ehealth.technicalconnector.session.Session.getInstance().unloadSession();
        }
        
        /**
         * Test the sendMessage operation from the eHealthBox Service through the use of the Business Connector. This test creates and sends a
         * message to a predefined eHealthBox, based on a person's INSS
         * 
         * The following main steps are done: - Create the parameters of the new message - Invoke the business connector - Verify the response
         * 
         * @
         */
        [Test]
        public void testSendNewsEncryptedMessage()  {
            try {
                /*
                 * Create the parameters of the new message
                 */
                SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();


                NewsMessage news = new NewsMessage();
                news.getDocument(). setTitle("Encrypted news " + new java.util.Date());
                news.getDocument(). setContent("eureka".getBytes());
                news.getDocument().setFilename("test.txt");
                news.getDocument().setMimeType("text/xml");
                news.setDestinations(getDestination());
                news.setImportant(true);
                news.setEncrypted(true);

                SendMessageRequest request = builder.buildMessage(news);

                CustomMetaType type = new CustomMetaType();
                type.setValue("");
                type.setKey("");


                /*
                 * Invoke the business connector framework's eHealthBox's sendMessage operation
                 */

                EhealthBoxServiceV3 service = ServiceFactory.getEhealthBoxServiceV3();
                SendMessageResponse response = service.sendMessage(request);

                /*
                 * Verify the response
                 */
                // check if there are no errors
                Assert.AreEqual("100", response.getStatus().getCode());
                // check if a messageId has been returned
                Assert.IsNotNull(response.getId());

            } catch (Exception e) {
                System.Console.WriteLine(e.getMessage());
                Assert.Fail(e.getMessage());
            }
        }

        /**
         * 
         * @
         */
        [Test]
        public void testSendNewsMessage()  {
            /*
             * Create the parameters of the new message
             */
            SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();


            NewsMessage news = new NewsMessage();
            news.getDocument().setTitle("News " + new java.util.Date());
            news.getDocument().setContent("eureka".getBytes());
            news.getDocument().setFilename("test.txt");

            news.setDestinations(getDestination());
            news.setImportant(true);
            news.setEncrypted(false);

            SendMessageRequest request = builder.buildMessage(news);


            /*
             * Invoke the business connector framework's eHealthBox's sendMessage operation
             */
            EhealthBoxServiceV3 service = ServiceFactory.getEhealthBoxServiceV3();
            SendMessageResponse response = service.sendMessage(request);

            /*
             * Verify the response
             */
            // check if there are no errors
            Assert.AreEqual("100", response.getStatus().getCode());
            // check if a messageId has been returned
            Assert.IsNotNull(response.getId());


        }

        /**
         * @
         */
        [Test]
        public void testSendEncryptedDocumentWithAnnex()  {
            /*
             * Create the parameters of the new message
             */
            SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

            DocumentMessage documentMsg = new DocumentMessage();
            documentMsg.setDestinations(getDestination());
            documentMsg.setImportant(false);
            documentMsg.setEncrypted(true);

            documentMsg.setFreeText("Free text:" + util.UUID.randomUUID());
            documentMsg.setPatientInss(TestPropertiesLoader.getProperties("be.ehealth.businessconnector.ehboxv3.test.properties").getProperty("test.user.niss.user2"));

            Document doc = new Document();
            doc.setTitle("Encrypted document " + new util.Date());
            //        Assembly assembly = Assembly.GetExecutingAssembly();
            //         TextReader inputStream = new StreamReader(assembly.GetManifestResourceStream("/be.ehealth.technicalconnector.properties"));
            //         doc.setContent(new ByteArrayInputStream(inputStream.ReadToEnd()));
            doc.setContent("eureka".getBytes());
            doc.setMimeType("text/plain");
            doc.setFilename("be.ehealth.businessconnector.properties");
            documentMsg.setDocument(doc);

            Document annex = new Document();
            annex.setTitle("properties");

            //        TextReader inputStream = new StreamReader(assembly.GetManifestResourceStream("/be.ehealth.technicalconnector.properties"));
            //         annex.setContent(new ByteArrayInputStream(inputStream.ReadToEnd()));
            annex.setContent("eureka".getBytes());
            annex.setFilename("be.ehealth.technicalconnector.properties");
            annex.setMimeType("text/plain");
            documentMsg.getAnnexList().add(annex);

            SendMessageRequest request = builder.buildMessage(documentMsg);
            /*
             * Invoke the business connector framework's eHealthBox's sendMessage operation
             */
            EhealthBoxServiceV3 service = ServiceFactory.getEhealthBoxServiceV3();
            SendMessageResponse response = service.sendMessage(request);

            /*
             * Verify the response
             */
            // check if there are no errors
            Assert.AreEqual("100", response.getStatus().getCode());
            // check if a messageId has been returned
            Assert.IsNotNull(response.getId());



        }

        /**
         * @
         */
        [Test]
        public void testSendDocumentWithAnnex()  {
            /*
             * Create the parameters of the new message
             */
            SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

            DocumentMessage documentMsg = new DocumentMessage();
            documentMsg.setDestinations(getDestination());
            documentMsg.setImportant(false);

            documentMsg.setFreeText("Free text:" + util.UUID.randomUUID());


            Document doc = new Document();
            doc.setTitle("Document " + new util.Date());
            //        Assembly assembly = Assembly.GetExecutingAssembly();
            //         TextReader inputStream = new StreamReader(assembly.GetManifestResourceStream("/be.ehealth.technicalconnector.properties"));
            //         doc.setContent(new ByteArrayInputStream(inputStream.ReadToEnd()));
            doc.setContent("eureka".getBytes());
            doc.setMimeType("text/plain");
            doc.setFilename("be.ehealth.businessconnector.properties");
            documentMsg.setDocument(doc);

            Document annex = new Document();
            annex.setTitle("properties");
            //         TextReader inputStream = new StreamReader(assembly.GetManifestResourceStream("/be.ehealth.technicalconnector.properties"));
            //         annex.setContent(new ByteArrayInputStream(inputStream.ReadToEnd()));
            annex.setContent("eureka".getBytes());
            annex.setFilename("be.ehealth.technicalconnector.properties");
            annex.setMimeType("text/plain");
            documentMsg.getAnnexList().add(annex);

            SendMessageRequest request = builder.buildMessage(documentMsg);
            /*
             * Invoke the business connector framework's eHealthBox's sendMessage operation
             */
            EhealthBoxServiceV3 service = ServiceFactory.getEhealthBoxServiceV3();
            SendMessageResponse response = service.sendMessage(request);

            /*
             * Verify the response
             */
            // check if there are no errors
            Assert.AreEqual("100", response.getStatus().getCode());
            // check if a messageId has been returned
            Assert.IsNotNull(response.getId());

        }

        private java.util.List getDestination() {
            java.util.List addresseeList = new java.util.ArrayList();
            Addressee addressee = new Addressee(IdentifierType.SSIN);
            addressee.setId(TestPropertiesLoader.getProperties(".\\be.ehealth.businessconnector.ehboxv3.test.properties").getProperty("test.user.niss.user1"));
            addressee.setQuality(QualityType.GENERAL_PRACTIONER_SSIN);
            // addressee.setApplicationId(applicationId)
            addresseeList.add(addressee);

            return addresseeList;
        }

        /**
         * @
         */
        [Test]
        public void testSendDocumentWithNullAnnex()  {
            /*
             * Create the parameters of the new message
             */
            SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

            DocumentMessage documentMsg = new DocumentMessage();
            documentMsg.setDestinations(getDestination());
            documentMsg.setImportant(false);

            documentMsg.setFreeText("Free text:" + util.UUID.randomUUID());

            Document doc = new Document();
            doc.setTitle(documentMsg.getPublicationId() + " Döé\"'(§è!çà)-ument   |; ¢¾ñ");
            //        Assembly assembly = Assembly.GetExecutingAssembly();
            //         TextReader inputStream = new StreamReader(assembly.GetManifestResourceStream("/be.ehealth.technicalconnector.properties"));
            //         doc.setContent(new ByteArrayInputStream(inputStream.ReadToEnd()));
            doc.setContent("eureka".getBytes());
            doc.setMimeType("text/plain");
            doc.setFilename("be.ehealth.businessconnector.properties");
            documentMsg.setDocument(doc);

            Document annex = new Document();
            annex.setTitle("properties");
            annex.setContent(new byte[]{});
            annex.setFilename("be.ehealth.technicalconnector.properties");
            annex.setMimeType("text/plain");
            documentMsg.getAnnexList().add(annex);

            SendMessageRequest request = builder.buildMessage(documentMsg);

            /*
             * Invoke the business connector framework's eHealthBox's sendMessage operation
             */
            EhealthBoxServiceV3 service = ServiceFactory.getEhealthBoxServiceV3();
            SendMessageResponse response = service.sendMessage(request);

            /*
             * Verify the response
             */
            // check if there are no errors
            Assert.AreEqual("100", response.getStatus().getCode());
            // check if a messageId has been returned
            Assert.IsNotNull(response.getId());

        }
    }
}
