/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.config.impl;

import java.util.List;

import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.LoggingRule;
import be.fgov.ehealth.technicalconnector.tests.log4j.TestAppender;
import be.fgov.ehealth.technicalconnector.tests.utils.AssertTools;


/**
 * Test to verify that the {@link be.ehealth.technicalconnector.config.ConfigurationModule} {@link ConfigurationModuleVersion}
 *
 * @author EHP
 */
public class ConfigurationModuleVersionTest {

    private TestAppender appender = new TestAppender();

    @Rule
    public LoggingRule logging = LoggingRule.with().appender(appender).and().consoleAppender().build();

    @Test
    public void test() throws Exception {
        new ConfigurationModuleVersion().init(null);

        List<LoggingEvent> logEvents = appender.getLogEvents();
        if (logEvents.size() == 0) {
            Assert.fail("No log events");
        }

        LoggingEvent lastEntry = logEvents.get(logEvents.size() - 1);
        AssertTools.assertLoggingEvent(lastEntry, "debug", ConfigurationModuleVersion.class, "\\[CP Content\\] .*");

    }
}