/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genins.service.impl;

import be.ehealth.businessconnector.genins.exception.GenInsBusinessConnectorException;
import be.ehealth.businessconnector.genins.service.GenInsService;
import be.ehealth.businessconnector.genins.service.ServiceFactory;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.fgov.ehealth.genericinsurability.core.v1.CommonInputType;
import be.fgov.ehealth.genericinsurability.protocol.v1.GetInsurabilityAsFlatRequest;
import be.fgov.ehealth.genericinsurability.protocol.v1.GetInsurabilityAsFlatResponse;
import be.fgov.ehealth.genericinsurability.protocol.v1.GetInsurabilityAsXmlOrFlatRequestType;
import be.fgov.ehealth.genericinsurability.protocol.v1.GetInsurabilityRequest;
import be.fgov.ehealth.genericinsurability.protocol.v1.GetInsurabilityResponse;
import java.net.MalformedURLException;
import javax.xml.soap.SOAPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenInsServiceImpl
implements GenInsService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final Logger LOG = LoggerFactory.getLogger(GenInsServiceImpl.class);
    private static final String GENINSBEGINNING = "GeninsServiceImpl : ";

    @Override
    public GetInsurabilityAsFlatResponse getInsurabilityAsFlat(SAMLToken token, GetInsurabilityAsXmlOrFlatRequestType request) throws GenInsBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        GetInsurabilityAsFlatResponse response = null;
        GetInsurabilityAsFlatRequest genericReq = new GetInsurabilityAsFlatRequest();
        this.dozer(request, (GetInsurabilityAsXmlOrFlatRequestType)genericReq);
        try {
            GenericRequest service = ServiceFactory.getGeninsPort(token);
            service.setPayload((Object)genericReq);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            response = (GetInsurabilityAsFlatResponse)xmlResponse.asObject(GetInsurabilityAsFlatResponse.class);
        }
        catch (MalformedURLException e) {
            LOG.error(GENINSBEGINNING + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, new Object[]{"genins " + e.getMessage()});
        }
        catch (SOAPException e) {
            LOG.error(GENINSBEGINNING + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        return response;
    }

    @Override
    public GetInsurabilityResponse getInsurability(SAMLToken token, GetInsurabilityAsXmlOrFlatRequestType requestType) throws GenInsBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        GetInsurabilityResponse response = null;
        GetInsurabilityRequest request = new GetInsurabilityRequest();
        this.dozer(requestType, (GetInsurabilityAsXmlOrFlatRequestType)request);
        try {
            GenericRequest service = ServiceFactory.getGeninsPort(token);
            service.setPayload((Object)request);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            response = (GetInsurabilityResponse)xmlResponse.asObject(GetInsurabilityResponse.class);
        }
        catch (MalformedURLException e) {
            LOG.error(GENINSBEGINNING + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, new Object[]{"genins " + e.getMessage()});
        }
        catch (SOAPException e) {
            LOG.error(GENINSBEGINNING + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
        return response;
    }

    private void dozer(GetInsurabilityAsXmlOrFlatRequestType source, GetInsurabilityAsXmlOrFlatRequestType destination) {
        destination.setCommonInput(source.getCommonInput());
        destination.setRecordCommonInput(source.getRecordCommonInput());
        destination.setRequest(source.getRequest());
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetInsurabilityAsFlatRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetInsurabilityAsFlatResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetInsurabilityAsXmlOrFlatRequestType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetInsurabilityRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetInsurabilityResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{CommonInputType.class});
    }
}

