/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.addressbook.integration;

import java.util.List;

import org.joda.time.DateTime;
import org.junit.Assert;

import be.fgov.ehealth.aa.complextype.v1.HealthCareProfessional;
import be.fgov.ehealth.addressbook.core.v1.IndividualContactInformationType;
import be.fgov.ehealth.addressbook.core.v1.OrganizationContactInformationType;
import be.fgov.ehealth.addressbook.protocol.v1.GetOrganizationContactInfoRequest;
import be.fgov.ehealth.addressbook.protocol.v1.GetOrganizationContactInfoResponse;
import be.fgov.ehealth.addressbook.protocol.v1.GetProfessionalContactInfoRequest;
import be.fgov.ehealth.addressbook.protocol.v1.GetProfessionalContactInfoResponse;
import be.fgov.ehealth.addressbook.protocol.v1.HealthCareOrganization;
import be.fgov.ehealth.addressbook.protocol.v1.SearchOrganizationsRequest;
import be.fgov.ehealth.addressbook.protocol.v1.SearchOrganizationsResponse;
import be.fgov.ehealth.addressbook.protocol.v1.SearchProfessionalsRequest;
import be.fgov.ehealth.addressbook.protocol.v1.SearchProfessionalsResponse;

/**
 * @author EH054
 *
 */
public class AddressbookTestUtils {

    private final static String ORG_NIHII = "71089914";

    private final static String ORG_TYPE = "HOSPITAL";

    private final static String ORG_NAME = "Hospital wilmar 1";

    private final static String PROF_NIHII = "13378872004";

    private final static String PROF_FIRSTNAME = "GEERT KAMIEL";

    private final static String PROF_LASTNAME = "GOETHALS";

    public static GetOrganizationContactInfoRequest createGetOrganizationContactInfoRequest() {
        GetOrganizationContactInfoRequest request = new GetOrganizationContactInfoRequest();
        request.setNIHII(ORG_NIHII);
        request.setIssueInstant(DateTime.now());
        return request;
    }

    public static GetProfessionalContactInfoRequest createGetProfessionalContactInfo() {
        GetProfessionalContactInfoRequest request = new GetProfessionalContactInfoRequest();
        request.setNIHII(PROF_NIHII);
        request.setIssueInstant(DateTime.now());
        return request;
    }

    public static SearchOrganizationsRequest createSearchOrganizationsRequest() {
        SearchOrganizationsRequest request = new SearchOrganizationsRequest();
        request.setNIHII(ORG_NIHII);
        request.setIssueInstant(DateTime.now());
        request.setOffset(1);
        request.setMaxElements(10);
        return request;
    }

    public static SearchProfessionalsRequest createSearchProfessionalsRequest() {
        SearchProfessionalsRequest request = new SearchProfessionalsRequest();
        request.setNIHII(PROF_NIHII);
        request.setIssueInstant(DateTime.now());
        request.setOffset(1);
        request.setMaxElements(10);
        return request;
    }

    public static void verifyResponseGetOrganizationContactInfo(GetOrganizationContactInfoResponse response) {
        OrganizationContactInformationType informations = response.getOrganizationContactInformation();

        Assert.assertEquals(ORG_NIHII, informations.getId().getValue());

        Assert.assertNotNull(informations.getNames());
        Assert.assertNotEquals(0, informations.getNames().size());
        Assert.assertEquals(ORG_NAME, informations.getNames().get(0).getValue());

        Assert.assertNotNull(informations.getOrganizationTypeCodes());
        Assert.assertNotEquals(0, informations.getOrganizationTypeCodes().size());
        Assert.assertEquals(ORG_TYPE, informations.getOrganizationTypeCodes().get(0).getValue());
    }

    public static void verifyResponseGetProfessionalContactInfo(GetProfessionalContactInfoResponse response) {
        Assert.assertNotNull(response);
        IndividualContactInformationType informations = response.getIndividualContactInformation();
        Assert.assertNotNull(informations);
        Assert.assertEquals(PROF_FIRSTNAME, informations.getFirstName());
        Assert.assertEquals(PROF_LASTNAME, informations.getLastName());
        Assert.assertNotEquals(0, informations.getProfessionalInformations().size());
    }

    public static void verifySearchOrganizationsResponse(SearchOrganizationsResponse response) {
        List<HealthCareOrganization> organizations = response.getHealthCareOrganizations();

        Assert.assertNotNull(organizations);
        Assert.assertNotEquals(0, organizations.size());

        HealthCareOrganization informations = organizations.get(0);

        Assert.assertEquals(ORG_NIHII, informations.getId().getValue());

        Assert.assertNotNull(informations.getNames());
        Assert.assertNotEquals(0, informations.getNames().size());
        Assert.assertEquals(ORG_NAME, informations.getNames().get(0).getValue());

        Assert.assertNotNull(informations.getOrganizationTypeCodes());
        Assert.assertNotEquals(0, informations.getOrganizationTypeCodes().size());
        Assert.assertEquals(ORG_TYPE, informations.getOrganizationTypeCodes().get(0).getValue());
    }

    public static void verifySearchProfessionalsResponse(SearchProfessionalsResponse response) {
        List<HealthCareProfessional> professionals = response.getHealthCareProfessionals();

        Assert.assertNotNull(professionals);
        Assert.assertNotEquals(0, professionals.size());

        HealthCareProfessional informations = professionals.get(0);

        Assert.assertEquals(PROF_FIRSTNAME, informations.getFirstName());
        Assert.assertEquals(PROF_LASTNAME, informations.getLastName());
        Assert.assertNotEquals(0, informations.getProfessions().size());
    }
}
