/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModuleBootstrap
implements ConfigurationModule {
    private static List<ModuleBootstrapHook> registry = new ArrayList<ModuleBootstrapHook>();
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleBootstrap.class);
    public static final String DEFAULT_MODULEBOOTSTRAP_LOCATION = "META-INF/connector.bootstrap";
    public static final String PROP_MODULE_BOOTSTRAP = "be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap.module";

    public static void register(ModuleBootstrapHook hook) {
        registry.add(hook);
    }

    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        LOG.debug("Initializing ConfigurationModule " + this.getClass().getName());
        HashSet<String> configuredModules = new HashSet<String>();
        if (config != null) {
            configuredModules.addAll(config.getMatchingProperties(PROP_MODULE_BOOTSTRAP));
        }
        configuredModules.addAll(ConfigurationModuleBootstrap.loadAllProperties(DEFAULT_MODULEBOOTSTRAP_LOCATION));
        for (String string : configuredModules) {
            try {
                Class<?> provider = Class.forName(string);
                registry.add((ModuleBootstrapHook)provider.newInstance());
            }
            catch (Exception e) {
                LOG.warn("Unable to load module [" + string + "]", (Throwable)e);
            }
        }
        for (ModuleBootstrapHook moduleBootstrapHook : registry) {
            DateTime start = new DateTime();
            moduleBootstrapHook.bootstrap();
            LOG.debug("ConfigurationModule [" + moduleBootstrapHook.getClass() + "] loaded in " + new Duration((ReadableInstant)start, (ReadableInstant)new DateTime()));
        }
    }

    @Override
    public void unload() throws TechnicalConnectorException {
        LOG.debug("Unloading ConfigurationModule " + this.getClass().getName());
    }

    private static Set<String> loadAllProperties(String resourceName) throws TechnicalConnectorException {
        HashSet<String> result = new HashSet<String>();
        Validate.notNull((Object)resourceName, (String)"Resource name must not be null");
        ClassLoader classLoaderToUse = ConfigurationModuleBootstrap.getDefaultClassLoader();
        try {
            Enumeration<URL> urls;
            Enumeration<URL> enumeration = urls = classLoaderToUse != null ? classLoaderToUse.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
            while (urls.hasMoreElements()) {
                ConfigurationModuleBootstrap.processUrl(result, urls.nextElement());
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to obtain classloader", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processUrl(Set<String> result, URL url) {
        InputStream is = null;
        BufferedReader br = null;
        try {
            String strLine;
            is = ConnectorIOUtils.getResourceAsStream(url.toExternalForm());
            br = new BufferedReader(new InputStreamReader(is));
            while ((strLine = br.readLine()) != null) {
                result.add(strLine);
            }
        }
        catch (Exception e) {
            try {
                LOG.warn("Unable to load read file [" + url + "]", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(br, is);
                throw throwable;
            }
            ConnectorIOUtils.closeQuietly(br, is);
        }
        ConnectorIOUtils.closeQuietly(br, is);
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception ex) {
            LOG.debug("Cannot access thread context ClassLoader - falling back...", (Throwable)ex);
        }
        if (cl == null) {
            LOG.debug("No thread context class loader -> use class loader of this class.");
            cl = ConfigurationModuleBootstrap.class.getClassLoader();
            if (cl == null) {
                LOG.debug("getClassLoader() returning null indicates the bootstrap ClassLoader");
                try {
                    cl = ClassLoader.getSystemClassLoader();
                }
                catch (Exception ex) {
                    LOG.debug("Cannot access system ClassLoader - oh well, maybe the caller can live with null...", (Throwable)ex);
                }
            }
        }
        return cl;
    }

    public static interface ModuleBootstrapHook {
        public void bootstrap();
    }
}

