/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.cache;

import be.ehealth.technicalconnector.cache.Cache;
import be.ehealth.technicalconnector.cache.impl.HashMapCache;
import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;

public final class CacheFactory {
    private static final String PROP_CACHE_MEMORY_IMPL = "be.ehealth.technicalconnector.cache.memory.impl";
    private static final String DEFAULT_CACHE_MEMORY_IMPL = HashMapCache.class.getName();
    private static final String PROP_CACHE_PERSISTENT_IMPL = "be.ehealth.technicalconnector.cache.persistent.impl";
    private static final String DEFAULT_CACHE_PERSISTENT_IMPL = HashMapCache.class.getName();

    public static <K, V> Cache<K, V> newInstance(CacheType cacheType) {
        try {
            ConfigurableFactoryHelper helper;
            switch (cacheType) {
                case MEMORY: {
                    helper = new ConfigurableFactoryHelper(PROP_CACHE_MEMORY_IMPL, DEFAULT_CACHE_MEMORY_IMPL);
                    break;
                }
                case PERSISTENT: {
                    helper = new ConfigurableFactoryHelper(PROP_CACHE_PERSISTENT_IMPL, DEFAULT_CACHE_PERSISTENT_IMPL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported cache type [" + (Object)((Object)cacheType) + "]");
                }
            }
            return (Cache)helper.getImplementation();
        }
        catch (TechnicalConnectorException e) {
            throw new ConfigurationException(e);
        }
    }

    public static enum CacheType {
        PERSISTENT,
        MEMORY;

    }
}

