/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import be.fgov.ehealth.etee.crypto.policies.ForwardingMap;
import be.fgov.ehealth.etee.crypto.policies.SigningOption;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.util.HashMap;
import java.util.Map;

public final class SigningOptions
extends ForwardingMap<SigningOption, Object> {
    private static final long DEFAULT_CLOCK_SKEW = 300000L;
    private static final int DEFAULT_SIGNING_TIME_EXPIRATION = 5;
    private final Map<SigningOption, Object> delegate = new HashMap<SigningOption, Object>();

    public SigningOptions() {
        this.delegate.put(SigningOption.SIGNING_TIME_EXPIRATION, 5);
        this.delegate.put(SigningOption.CLOCK_SKEW, 300000L);
        this.delegate.put(SigningOption.SIGNING_TIME_TRUST_IMPLICIT, Boolean.FALSE);
        this.delegate.put(SigningOption.TSA_TRUST_STORE, null);
        this.delegate.put(SigningOption.NON_REPUDIATION, Boolean.TRUE);
    }

    public static SigningOptions defaultOptions() {
        return new SigningOptions();
    }

    public static SigningOptions create() {
        SigningOptions options = SigningOptions.defaultOptions();
        options.clear();
        return options;
    }

    public SigningOptions set(SigningOption option, Object value) {
        if (value != null) {
            this.delegate.put(option, value);
        }
        return this;
    }

    public SigningOptions setAll(Map<SigningOption, Object> options) {
        for (Map.Entry<SigningOption, Object> entry : options.entrySet()) {
            if (entry.getValue() == null) continue;
            this.delegate.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String getString(SigningOption signingOption) {
        return this.valueOf((Object)signingOption, String.class);
    }

    public Boolean getBoolean(SigningOption signingOption) {
        return this.valueOf((Object)signingOption, Boolean.class);
    }

    public KeyStore getKeyStore(SigningOption signingOption) {
        return this.valueOf((Object)signingOption, KeyStore.class);
    }

    public CertStore getCertStore(SigningOption signingOption) {
        return this.valueOf((Object)signingOption, CertStore.class);
    }

    public Long getLong(SigningOption signingOption) {
        return this.valueOf((Object)signingOption, Long.class);
    }

    public Integer getInteger(SigningOption signingOption) {
        return this.valueOf((Object)signingOption, Integer.class);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SigningOptions : ");
        for (Map.Entry<SigningOption, Object> entry : this.delegate.entrySet()) {
            stringBuilder.append(String.format(" [%s = %s] ", new Object[]{entry.getKey(), entry.getValue()}));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Map && obj.equals(this.delegate);
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    @Override
    protected Map<SigningOption, Object> delegate() {
        return this.delegate;
    }
}

