/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.EnvelopedDataDecrypterResult;
import be.fgov.ehealth.etee.crypto.decrypt.KeyLengthVerifier;
import be.fgov.ehealth.etee.crypto.decrypt.UnsealUtils;
import be.fgov.ehealth.etee.crypto.policies.EncryptionCredential;
import be.fgov.ehealth.etee.crypto.policies.EncryptionCredentials;
import be.fgov.ehealth.etee.crypto.policies.EncryptionPolicy;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.status.NotificationFatal;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKEKEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;

class EnvelopedDataDecrypter {
    private static final Logger LOGGER = Logger.getLogger(EnvelopedDataDecrypter.class);
    private final EncryptionPolicy privateKeyEncryptionPolicy;
    private final EncryptionPolicy secretKeyEncryptionPolicy;
    private final Map<String, PrivateKey> encryptionCredentials;

    public EnvelopedDataDecrypter(EncryptionPolicy privateKeyEncryptionPolicy, EncryptionCredential[] encryptionCredentials, EncryptionPolicy secretKeyEncryptionPolicy) {
        this.privateKeyEncryptionPolicy = privateKeyEncryptionPolicy;
        this.secretKeyEncryptionPolicy = secretKeyEncryptionPolicy;
        this.encryptionCredentials = EncryptionCredentials.toMap(encryptionCredentials);
    }

    public EnvelopedDataDecrypterResult decryptData(byte[] encryptedData) {
        return this.decryptData(encryptedData, null);
    }

    public EnvelopedDataDecrypterResult decryptData(InputStream encryptedData) {
        return this.decryptData(encryptedData, null);
    }

    public EnvelopedDataDecrypterResult decryptData(byte[] encryptedData, SecretKey kek) {
        return this.processData(encryptedData, null, kek);
    }

    public EnvelopedDataDecrypterResult decryptData(InputStream encryptedData, SecretKey kek) {
        return this.processData(null, encryptedData, kek);
    }

    private EnvelopedDataDecrypterResult processData(byte[] encryptedData, InputStream encryptedDataStream, SecretKey kek) {
        LOGGER.info((Object)"Decrypting");
        CMSEnvelopedDataParser envelopedDataParser = null;
        try {
            envelopedDataParser = encryptedData != null ? new CMSEnvelopedDataParser(encryptedData) : new CMSEnvelopedDataParser(encryptedDataStream);
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            return new EnvelopedDataDecrypterResult(NotificationFatal.ENVELOPED_DATA_STRUCTURE_INCORRECT);
        }
        EnvelopedDataDecrypterResult rslt = new EnvelopedDataDecrypterResult();
        this.decryptEnvelopedData(envelopedDataParser, kek, rslt);
        return rslt;
    }

    private void decryptEnvelopedData(CMSEnvelopedDataParser envelopedDataParser, SecretKey kek, EnvelopedDataDecrypterResult rslt) {
        boolean mustUseKekToDecrypt = kek != null;
        try {
            List<RecipientInformation> recipientInfos = this.getRecipientInfo(envelopedDataParser);
            LOGGER.info((Object)("Enveloped-Data contains " + recipientInfos.size() + " recipientInfos"));
            LOGGER.info((Object)("decrypting Enveloped-Data with " + (mustUseKekToDecrypt ? " given KEK" : " private keys")));
            boolean decryptionSucceeded = false;
            boolean containsKeyTransRinfo = false;
            boolean containsKekRinfo = false;
            Iterator<RecipientInformation> it = recipientInfos.iterator();
            while (!decryptionSucceeded && it.hasNext()) {
                RecipientInformation recipientInfo = it.next();
                LOGGER.info((Object)("recipient rid: " + recipientInfo.getRID()));
                if (!mustUseKekToDecrypt && recipientInfo instanceof KeyTransRecipientInformation) {
                    containsKeyTransRinfo = true;
                    this.checkEncryptionAlgorithms(this.privateKeyEncryptionPolicy, recipientInfo, envelopedDataParser, rslt);
                    decryptionSucceeded = this.decryptKeyTransRecipientInfo((KeyTransRecipientInformation)recipientInfo, rslt);
                    continue;
                }
                if (!mustUseKekToDecrypt || !(recipientInfo instanceof KEKRecipientInformation)) continue;
                this.checkEncryptionAlgorithms(this.secretKeyEncryptionPolicy, recipientInfo, envelopedDataParser, rslt);
                KeyLengthVerifier.verifySecretKeyLength(this.secretKeyEncryptionPolicy, rslt, kek);
                containsKekRinfo = true;
                decryptionSucceeded = this.decryptKekRecipientInfo((KEKRecipientInformation)recipientInfo, kek, rslt);
            }
            this.verifyDecryptionStatus(rslt, mustUseKekToDecrypt, decryptionSucceeded, containsKeyTransRinfo, containsKekRinfo);
        }
        catch (CMSException e) {
            LOGGER.warn((Object)"Failed to decrypt enveloped data", (Throwable)e);
            this.handleCMSError(rslt, e);
        }
    }

    private void handleCMSError(EnvelopedDataDecrypterResult rslt, CMSException e) {
        if (e.getCause() instanceof NoSuchPaddingException) {
            rslt.getErrors().add(NotificationError.DECRYPTION_SYMMETRIC_KEY_ALGORITHM_PADDING_UNAUTHORIZED);
        } else if (e.getCause() instanceof BadPaddingException) {
            rslt.getErrors().add(NotificationError.DECRYPTION_SYMMETRIC_KEY_ALGORITHM_PADDING_UNAUTHORIZED);
        } else if (e.getCause() instanceof InvalidKeyException) {
            rslt.getErrors().add(NotificationError.DECRYPTION_SYMMETRIC_KEY_LENGTH_UNAUTHORIZED);
        } else {
            rslt.copyNotifications(new EnvelopedDataDecrypterResult(NotificationFatal.ENVELOPED_DATA_STRUCTURE_INCORRECT));
        }
    }

    private boolean decryptKekRecipientInfo(KEKRecipientInformation recipientInfo, SecretKey kek, EnvelopedDataDecrypterResult rslt) {
        LOGGER.debug((Object)("Decrypting RecipientInfo with KEK ID " + Arrays.toString(UnsealUtils.getKekId((RecipientInformation)recipientInfo)) + " with given KEK."));
        boolean decryptionSucceeded = false;
        try {
            CMSTypedStream recData = recipientInfo.getContentStream((Recipient)new JceKEKEnvelopedRecipient(kek));
            InputStream is = recData.getContentStream();
            rslt.setData(is);
            decryptionSucceeded = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("EnvelopedData could not be decrypted with given kek. RecipientInfo's KEK ID is " + Arrays.toString(UnsealUtils.getKekId((RecipientInformation)recipientInfo))), (Throwable)e);
        }
        return decryptionSucceeded;
    }

    private boolean decryptKeyTransRecipientInfo(KeyTransRecipientInformation recipientInfo, EnvelopedDataDecrypterResult rslt) throws CMSException {
        boolean decryptionSucceeded = false;
        String kekId = ((KeyTransRecipientId)recipientInfo.getRID()).getSerialNumber().toString();
        PrivateKey decryptionKey = this.encryptionCredentials.get(kekId);
        if (decryptionKey != null) {
            LOGGER.info((Object)("Found decryption key for RecipientInfo with SerialNumber: " + kekId));
            KeyLengthVerifier.verifyPrivateKeyLength(rslt, decryptionKey, this.privateKeyEncryptionPolicy.getKeksize());
            CMSTypedStream recData = null;
            try {
                recData = recipientInfo.getContentStream((Recipient)new JceKeyTransEnvelopedRecipient(decryptionKey));
                InputStream is = recData.getContentStream();
                rslt.setData(is);
                decryptionSucceeded = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)("EnvelopedData could not be decrypted with given kek. RecipientInfo's KEK ID is " + kekId), (Throwable)e);
            }
        } else {
            LOGGER.warn((Object)("no decryption key found for RecipientInfo with serial nr : " + kekId));
        }
        return decryptionSucceeded;
    }

    private void checkEncryptionAlgorithms(EncryptionPolicy encryptionPolicy, RecipientInformation recipientInformation, CMSEnvelopedDataParser envelopedDataParser, EnvelopedDataDecrypterResult result) {
        this.checkContentEncryptionAlgorithm(encryptionPolicy, envelopedDataParser, result);
        this.checkKeyEncryptionAlgorithm(encryptionPolicy, recipientInformation, result);
    }

    private void checkKeyEncryptionAlgorithm(EncryptionPolicy encryptionPolicy, RecipientInformation recipientInfo, EnvelopedDataDecrypterResult rslt) {
        String usedKeyEncryptionAlgoOID = recipientInfo.getKeyEncryptionAlgOID();
        boolean isAuthorizedKeyEncryptionAlgorithm = usedKeyEncryptionAlgoOID.equals(encryptionPolicy.getKeyEncryptionAlgorithmOID());
        if (!isAuthorizedKeyEncryptionAlgorithm) {
            LOGGER.warn((Object)("Unauthorized key encryption algorithm used in encrypted message.Applied algorithm : " + usedKeyEncryptionAlgoOID));
            rslt.getErrors().add(NotificationError.DECRYPTION_ASYMMETRIC_KEY_ALGORITHM_UNAUTHORIZED);
        } else {
            LOGGER.info((Object)"Key(s) encryption algorithm is OK.");
        }
    }

    private void checkContentEncryptionAlgorithm(EncryptionPolicy encryptionPolicy, CMSEnvelopedDataParser envelopedDataParser, EnvelopedDataDecrypterResult rslt) {
        String usedContentEncryptionAlgOID = envelopedDataParser.getEncryptionAlgOID();
        boolean isAuthorizedContentEncryptionAlgorithm = usedContentEncryptionAlgOID.equals(encryptionPolicy.getContentEncryptionAlgorithmOID());
        if (!isAuthorizedContentEncryptionAlgorithm) {
            LOGGER.warn((Object)("Unauthorized content encryption algorithm used in encrypted message. Applied algorithm : " + usedContentEncryptionAlgOID));
            rslt.getErrors().add(NotificationError.DECRYPTION_SYMMETRIC_KEY_ALGORITHM_UNAUTHORIZED);
        } else {
            LOGGER.info((Object)"Content encryption algorithm is OK.");
        }
    }

    private List<RecipientInformation> getRecipientInfo(CMSEnvelopedDataParser envelopedDataParser) {
        RecipientInformationStore recipients = envelopedDataParser.getRecipientInfos();
        return (List)recipients.getRecipients();
    }

    private void verifyDecryptionStatus(EnvelopedDataDecrypterResult rslt, boolean mustUseKekToDecrypt, boolean keyFound, boolean containsKeyTransRinfo, boolean containsKekRinfo) {
        if (!keyFound) {
            if (mustUseKekToDecrypt) {
                if (!containsKekRinfo) {
                    LOGGER.error((Object)"The EnvelopedData does not contain a KEKRecipientInformation");
                    rslt.copyNotifications(new EnvelopedDataDecrypterResult(NotificationFatal.ENVELOPED_DATA_CONTAINS_NO_KEKRECIPIENTINFOS));
                } else {
                    LOGGER.warn((Object)"The given SecretKey can not decrypt the KEKRecipientInformations in the EnvelopedData.");
                    rslt.copyNotifications(new EnvelopedDataDecrypterResult(NotificationFatal.SECRET_KEY_CAN_NOT_DECRYPT_KEKRECIPIENTINFOS));
                }
            } else if (!containsKeyTransRinfo) {
                LOGGER.error((Object)"The EnvelopedData does not contain a KeyTransRecipientInformation.");
                rslt.copyNotifications(new EnvelopedDataDecrypterResult(NotificationFatal.ENVELOPED_DATA_CONTAINS_NO_KEYTRANSRECIPIENTINFOS));
            } else {
                LOGGER.warn((Object)"No private key found for the KeyTransRecipientInformations in the EnvelopedData.");
                rslt.copyNotifications(new EnvelopedDataDecrypterResult(NotificationFatal.DECRYPTION_PRIVATE_KEY_NOT_FOUND));
            }
        }
    }
}

