/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.service.sso;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import be.ehealth.technicalconnector.enumeration.SsoProfile;
import be.ehealth.technicalconnector.service.ServiceFactory;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;


/**
 * IntegrationTest for the {@link SingleSignOnService}
 * 
 * @author EHP
 */
public class SingleSignOnServiceIntegrationTest {

    private static String relayState = "https://wwwintr2.ehealth.fgov.be/testsso";

    private SingleSignOnService sso;

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().build();

    @Before
    public void init() throws Exception {
        AssumeTools.isUserInteractionEnabled();
        sso = ServiceFactory.getSingleSignOnService();
    }

    @Test
    public void withSAML2Artifact() throws Exception {
        sso.signin(SsoProfile.SAML2_ARTIFACT, relayState);
    }

    @Test
    public void withSAML2ArtifactWithoutRelayState() throws Exception {
        sso.signin(SsoProfile.SAML2_ARTIFACT);
    }

    @Test
    public void withSAML2POST() throws Exception {
        sso.signin(SsoProfile.SAML2_POST, relayState);
    }

    @Test
    public void withSAML2POSTWithoutRelayState() throws Exception {
        sso.signin(SsoProfile.SAML2_POST);
    }
}
