/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveProperties
extends Properties {
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveProperties.class);
    private Properties uddi = new Properties();
    private Lookup[] lookupList = new Lookup[]{new RecursiveLookup(this), new UddiLookup(this.uddi, this), new SystemLookup(), new RecursiveLookup(this)};

    public RecursiveProperties() {
        RecursiveProperties.load("/uddi/uddi-default.properties", this.uddi);
        RecursiveProperties.load(this.getProperty("uddi.local.cache.dir", System.getProperty("java.io.tmpdir")) + File.separator + "uddi-local.properties", this.uddi);
    }

    private static void load(String location, Properties properties) {
        try {
            Properties props = new Properties();
            props.load(ConnectorIOUtils.getResourceAsStream(location));
            properties.putAll((Map<?, ?>)props);
        }
        catch (Exception e) {
            LOG.warn("Unable to add properties from location [" + location + "]");
        }
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        if (val == null && defaultValue != null) {
            LOG.debug("Resolving defaultValue [{}]", (Object)defaultValue);
            val = defaultValue;
            ArrayList<String> lookupKeys = new ArrayList<String>();
            for (Lookup lookup : this.lookupList) {
                val = lookup.process(val, lookupKeys);
            }
        }
        return val;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, new ArrayList<String>());
    }

    private String getProperty(String key, List<String> lookupKeys) {
        if (key == null) {
            return null;
        }
        String value = super.getProperty(key);
        if (StringUtils.isNotEmpty((String)value)) {
            for (Lookup lookup : this.lookupList) {
                value = lookup.process(value, lookupKeys);
            }
        }
        if (key.toLowerCase().startsWith("endpoint") && "true".equals(this.getProperty("remove.trail.withspaces", "true"))) {
            LOG.debug("Removing whitespace.");
            value = StringUtils.trim((String)value);
        }
        LOG.debug("Returning value [" + value + "] for property with key [" + key + "].");
        return value;
    }

    private static class SystemLookup
    extends AbstractLookup {
        SystemLookup() {
            super("$system{", "}");
        }

        @Override
        String getRefValue(String ref, List<String> lookupKeys) {
            LOG.debug("Looking system-key [" + ref + "]");
            return System.getProperty(ref);
        }
    }

    private static class UddiLookup
    extends AbstractLookup {
        private Properties uddi;
        private Properties config;

        public UddiLookup(Properties uddi, Properties config) {
            super("$uddi{", "}");
            this.uddi = uddi;
            this.config = config;
        }

        @Override
        String getRefValue(String ref, List<String> lookupKeys) {
            String env = this.config.getProperty("environment", "prd");
            String uddiKey = env + "-" + ref;
            LOG.debug("Looking uddi-key [" + uddiKey + "]");
            return this.uddi.getProperty(uddiKey);
        }
    }

    private static class RecursiveLookup
    extends AbstractLookup {
        private RecursiveProperties props;

        public RecursiveLookup(RecursiveProperties props) {
            super("${", "}");
            this.props = props;
        }

        @Override
        String getRefValue(String ref, List<String> lookupKeys) {
            return this.props.getProperty(ref, lookupKeys);
        }
    }

    private static abstract class AbstractLookup
    implements Lookup {
        private Pattern pattern;
        private String startTag;
        private String endTag;

        private AbstractLookup(String startTag, String endTag) {
            this.pattern = Pattern.compile(".*" + Pattern.quote(startTag) + ".*" + Pattern.quote(endTag) + ".*");
            this.startTag = startTag;
            this.endTag = endTag;
        }

        @Override
        public String process(String value, List<String> lookupKeys) {
            if (value == null) {
                return null;
            }
            if (this.pattern.matcher(value).matches()) {
                HashSet<String> refs = new HashSet<String>(Arrays.asList(StringUtils.substringsBetween((String)value, (String)this.startTag, (String)this.endTag)));
                for (String ref : refs) {
                    if (lookupKeys.contains(ref)) {
                        throw new ConfigurationException("A circular reference detected.");
                    }
                    lookupKeys.add(ref);
                    String refValue = this.getRefValue(ref, lookupKeys);
                    String refTag = this.startTag + ref + this.endTag;
                    if (refValue != null) {
                        value = value.replace(refTag, refValue);
                        continue;
                    }
                    value = null;
                }
            }
            return value;
        }

        abstract String getRefValue(String var1, List<String> var2);
    }

    private static interface Lookup {
        public String process(String var1, List<String> var2);
    }
}

