/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.mediprimav2.session;

import static org.junit.Assert.assertTrue;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

import be.ehealth.businessconnector.mediprimav2.session.MediprimaConsultationSessionService;
import be.ehealth.businessconnector.mediprimav2.session.MediprimaSessionServiceFactory;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;

import be.ehealth.businessconnector.test.testcommons.utils.SessionTestUtils;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionManager;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.RestoreSystemProperties;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * Test class for MediprimaSessionServiceFactory
 * @author EHP
 *
 * @since
 *
 */
public class MediprimaSessionServiceFactoryIntegrationTest {


    private SessionManager noSessionManager;


    @ClassRule
    public static RuleChain chain = RuleChain.outerRule(new RestoreSystemProperties()).around(SessionRule.withInactiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").build());

    @Before
    public void initialize() {
        noSessionManager = EasyMock.createNiceMock(SessionManager.class);
    }


    /**
     * Test method for {@link MediprimaSessionServiceFactory#getConsultationMediprimaSession()}.
     */
    @Test
    public void testGetMediprimaSession() throws ConnectorException {
        try {
            Session.setSessionManager(SessionTestUtils.getDummySessionManager());
            MediprimaConsultationSessionService dicsSession = MediprimaSessionServiceFactory.getConsultationMediprimaSession();
            Assert.assertNotNull(dicsSession);
        } finally {
            Session.setSessionManager(null);
        }

    }



    @Test
    public void testConstructorIsPrivate() throws Exception {

        Constructor<MediprimaSessionServiceFactory> constructor = MediprimaSessionServiceFactory.class.getDeclaredConstructor();
        assertTrue("Constructor is not private", Modifier.isPrivate(constructor.getModifiers()));

        constructor.setAccessible(true);
        try {
            constructor.newInstance();
            Assert.fail("should have thrown UnsupportedOperationException");
        } catch (InvocationTargetException e) {
            Assert.assertTrue(e.getTargetException() instanceof UnsupportedOperationException);
        }
    }

}
