/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.dmg.mappers;

import be.ehealth.businessconnector.dmg.mappers.RoutingMapper;
import org.joda.time.DateTime;
import org.junit.Test;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unitils.reflectionassert.ReflectionComparatorMode;

import be.ehealth.business.mycarenetdomaincommons.domain.CareReceiverId;
import be.ehealth.business.mycarenetdomaincommons.domain.Routing;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.globalmedicalfile.core.v1.RoutingType;


/**
 * Test for {@link RoutingMapper}
 * 
 * @author EHP
 * 
 */
public class RoutingMapperTest {

    private static final Logger LOG = LoggerFactory.getLogger(RoutingMapperTest.class);


    @Test
    public void testRoutingMapper() throws Exception {
        MarshallerHelper<RoutingType, RoutingType> helper = new MarshallerHelper<RoutingType, RoutingType>(RoutingType.class, RoutingType.class);

        RoutingType routingExample = helper.toObject(ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream("/examples/routing.xml")));

        String niss = routingExample.getCareReceiver().getSsin();
        String mutuality = routingExample.getCareReceiver().getMutuality();
        String regWithMut = routingExample.getCareReceiver().getRegNrWithMut();
        DateTime dateReference = routingExample.getReferenceDate();

        // Create Routing object
        CareReceiverId careReceiver = new CareReceiverId(niss, regWithMut, mutuality);

        Routing input = new Routing();

        input.setPeriod(null);
        input.setCareReceiver(careReceiver);
        input.setReferenceDate(dateReference);

        RoutingType routingType = Mappers.getMapper(RoutingMapper.class).map(input);

        LOG.debug(helper.toString(routingType));

        org.unitils.reflectionassert.ReflectionAssert.assertReflectionEquals(routingExample, routingType, ReflectionComparatorMode.IGNORE_DEFAULTS);
    }
}
