/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.service.impl;

import be.ehealth.technicalconnector.beid.BeIDFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.impl.BeIDCredential;
import be.ehealth.technicalconnector.utils.ConfigurableImplementation;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.certra.core.v2.CertificateInfoType;
import be.fgov.ehealth.certra.core.v2.ContactDataType;
import be.fgov.ehealth.certra.core.v2.ContractType;
import be.fgov.ehealth.certra.core.v2.EHealthCertificateSigningRequestType;
import be.fgov.ehealth.certra.protocol.v2.GenerateCertificateRequest;
import be.fgov.ehealth.certra.protocol.v2.GenerateCertificateResponse;
import be.fgov.ehealth.certra.protocol.v2.GenerateContractRequest;
import be.fgov.ehealth.certra.protocol.v2.GenerateContractResponse;
import be.fgov.ehealth.certra.protocol.v2.GenerateRevocationContractRequest;
import be.fgov.ehealth.certra.protocol.v2.GenerateRevocationContractResponse;
import be.fgov.ehealth.certra.protocol.v2.GetActorQualitiesRequest;
import be.fgov.ehealth.certra.protocol.v2.GetActorQualitiesResponse;
import be.fgov.ehealth.certra.protocol.v2.GetCertificateInfoForAuthenticationCertificateRequest;
import be.fgov.ehealth.certra.protocol.v2.GetCertificateInfoForAuthenticationCertificateResponse;
import be.fgov.ehealth.certra.protocol.v2.GetCertificateInfoForCitizenRequest;
import be.fgov.ehealth.certra.protocol.v2.GetCertificateInfoForCitizenResponse;
import be.fgov.ehealth.certra.protocol.v2.GetCertificateRequest;
import be.fgov.ehealth.certra.protocol.v2.GetCertificateResponse;
import be.fgov.ehealth.certra.protocol.v2.GetExistingApplicationIdsRequest;
import be.fgov.ehealth.certra.protocol.v2.GetExistingApplicationIdsResponse;
import be.fgov.ehealth.certra.protocol.v2.GetGenericOrganizationTypesRequest;
import be.fgov.ehealth.certra.protocol.v2.GetGenericOrganizationTypesResponse;
import be.fgov.ehealth.certra.protocol.v2.RevokeRequest;
import be.fgov.ehealth.certra.protocol.v2.RevokeResponse;
import be.fgov.ehealth.certra.protocol.v2.SubmitCSRForForeignerRequest;
import be.fgov.ehealth.certra.protocol.v2.SubmitCSRForForeignerResponse;
import be.fgov.ehealth.commons.core.v2.Id;
import be.fgov.ehealth.commons.protocol.v2.RequestType;
import be.fgov.ehealth.commons.protocol.v2.StatusResponseType;
import be.fgov.ehealth.technicalconnector.ra.domain.ActorQualities;
import be.fgov.ehealth.technicalconnector.ra.domain.Certificate;
import be.fgov.ehealth.technicalconnector.ra.domain.ContractRequest;
import be.fgov.ehealth.technicalconnector.ra.domain.ForeignerRequest;
import be.fgov.ehealth.technicalconnector.ra.domain.GeneratedContract;
import be.fgov.ehealth.technicalconnector.ra.domain.GeneratedRevocationContract;
import be.fgov.ehealth.technicalconnector.ra.domain.NewCertificateContract;
import be.fgov.ehealth.technicalconnector.ra.domain.Organization;
import be.fgov.ehealth.technicalconnector.ra.domain.Result;
import be.fgov.ehealth.technicalconnector.ra.domain.RevocationContractRequest;
import be.fgov.ehealth.technicalconnector.ra.domain.RevocationRequest;
import be.fgov.ehealth.technicalconnector.ra.domain.SubmitCSRForForeignerResponseInfo;
import be.fgov.ehealth.technicalconnector.ra.enumaration.Status;
import be.fgov.ehealth.technicalconnector.ra.enumaration.UsageType;
import be.fgov.ehealth.technicalconnector.ra.mapper.MapperFactory;
import be.fgov.ehealth.technicalconnector.ra.service.AuthenticationCertificateRegistrationService;
import be.fgov.ehealth.technicalconnector.ra.utils.CertificateUtils;
import be.fgov.ehealth.technicalconnector.ra.utils.RaUtils;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationCertificateRegistrationServiceImpl
implements AuthenticationCertificateRegistrationService,
ConfigurableImplementation {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationCertificateRegistrationServiceImpl.class);
    private Credential authCred;
    private Credential signCred;

    @Override
    public Result<Certificate> generateCertificate(NewCertificateContract contract) throws TechnicalConnectorException {
        ContactDataType contactDataType = MapperFactory.mapper().asContactDataType(contract.getContact());
        GenerateCertificateRequest payload = new GenerateCertificateRequest();
        RaUtils.setCommonAttributes((RequestType)payload);
        EHealthCertificateSigningRequestType eHealthCSR = new EHealthCertificateSigningRequestType();
        eHealthCSR.setCSR(contract.getPkcs10DerEncoded());
        for (UsageType usageType : contract.getUsageTypes()) {
            eHealthCSR.getBaseServiceUsages().add(usageType.getServiceName());
        }
        eHealthCSR.setContactData(contactDataType);
        ContractType contractType = MapperFactory.mapper().asContractType(contract);
        eHealthCSR.setContract(contractType);
        payload.setEHealthCSR(eHealthCSR);
        String signedPayload = RaUtils.sign(payload, payload.getId(), this.signCred);
        return new Result<Certificate>(MapperFactory.mapper().asCertificate(RaUtils.invokeCertRa(signedPayload, "urn:be:fgov:ehealth:etee:certra:protocol:v2:generatecertificate", GenerateCertificateResponse.class).getResult()));
    }

    @Override
    public Result<X509Certificate[]> getCertificate(byte[] publicKeyIdentifier) throws TechnicalConnectorException {
        GetCertificateRequest request = new GetCertificateRequest();
        RaUtils.setCommonAttributes((RequestType)request);
        request.setPublicKeyIdentifier(publicKeyIdentifier);
        Result<GetCertificateResponse> resp = RaUtils.invokeCertRa(ConnectorXmlUtils.toString((Object)request), "urn:be:fgov:ehealth:etee:certra:protocol:v2:getcertificate", GetCertificateResponse.class);
        if (resp.getStatus().equals((Object)Status.OK)) {
            Object[] x509Certificates = new X509Certificate[]{};
            for (byte[] x509Certificate : resp.getResult().getX509Certificates()) {
                x509Certificates = (X509Certificate[])ArrayUtils.add((Object[])x509Certificates, (Object)CertificateUtils.toX509Certificate(x509Certificate));
            }
            return new Result<X509Certificate[]>((X509Certificate[])x509Certificates);
        }
        if (resp.getStatus().equals((Object)Status.PENDING)) {
            return new Result<X509Certificate[]>(resp.getTime());
        }
        return new Result<X509Certificate[]>("Unable to obtain certificate", resp.getCause());
    }

    @Override
    public Result<GeneratedContract> generateContract(ContractRequest contractRequest) throws TechnicalConnectorException {
        GenerateContractRequest generateContractRequest = MapperFactory.mapper().asGenerateContractRequest(contractRequest);
        RaUtils.setIssueInstant((RequestType)generateContractRequest);
        GenerateContractResponse generateContractResponse = RaUtils.invokeCertRa(ConnectorXmlUtils.toString((Object)generateContractRequest), "urn:be:fgov:ehealth:certra:protocol:v2:generateContract", GenerateContractResponse.class).getResult();
        GeneratedContract contract = MapperFactory.mapper().asGeneratedContract(generateContractResponse.getContract());
        contract.setContactData(contractRequest.getContactData());
        contract.setIdentifierType(IdentifierType.lookup((String)contractRequest.getCertificateIdentifier().getActor().getIds().get(0).getType(), null, (int)48));
        return new Result<GeneratedContract>(contract, (StatusResponseType)generateContractResponse);
    }

    @Override
    public Result<Void> revokeCertificate(RevocationRequest revocationRequest) throws TechnicalConnectorException {
        RevokeRequest revokeRequest = MapperFactory.mapper().asRevokeRequest(revocationRequest);
        RaUtils.setIssueInstant((RequestType)revokeRequest);
        String signedPayload = RaUtils.sign(revokeRequest, revokeRequest.getId(), this.signCred);
        RevokeResponse revokeResponse = RaUtils.invokeCertRa(signedPayload, "urn:be:fgov:ehealth:etee:certra:protocol:v2:revoke", RevokeResponse.class).getResult();
        return new Result<Void>((Void)null, (StatusResponseType)revokeResponse);
    }

    @Override
    public Result<GetGenericOrganizationTypesResponse> getOrganizationList() throws TechnicalConnectorException {
        GetGenericOrganizationTypesRequest req = new GetGenericOrganizationTypesRequest();
        RaUtils.setCommonAttributes((RequestType)req);
        return RaUtils.invokeCertRa(ConnectorXmlUtils.toString((Object)req), "urn:be:fgov:ehealth:certra:protocol:v2:getGenericOrganizationTypes", GetGenericOrganizationTypesResponse.class);
    }

    @Override
    public Result<ActorQualities> getActorQualities() throws TechnicalConnectorException {
        GetActorQualitiesRequest payload = new GetActorQualitiesRequest();
        RaUtils.setCommonAttributes((RequestType)payload);
        Id id = new Id();
        id.setValue(BeIDFactory.getBeIDInfo((String)"requestor", (boolean)false).getIdentity().getNationalNumber());
        id.setType(IdentifierType.SSIN.name());
        payload.setSSIN(id);
        String signedPayload = RaUtils.sign(payload, payload.getId(), this.authCred);
        GetActorQualitiesResponse response = RaUtils.invokeCertRa(signedPayload, "urn:be:fgov:ehealth:certra:protocol:v2:getActorQualities", GetActorQualitiesResponse.class).getResult();
        return new Result<ActorQualities>(MapperFactory.mapper().asActorQualities(response), (StatusResponseType)response);
    }

    @Override
    public Result<List<String>> getApplicationIdList(Organization organization) throws TechnicalConnectorException {
        GetExistingApplicationIdsRequest req = new GetExistingApplicationIdsRequest();
        RaUtils.setCommonAttributes((RequestType)req);
        Id id = new Id();
        id.setType(organization.getType().getType(48));
        id.setValue(organization.getId());
        req.setOrganizationIdentifier(id);
        Result<GetExistingApplicationIdsResponse> response = RaUtils.invokeCertRa(ConnectorXmlUtils.toString((Object)req), "urn:be:fgov:ehealth:etee:certra:protocol:v2:getexistingapplicationids", GetExistingApplicationIdsResponse.class);
        return new Result<List<String>>(response.getResult().getApplicationIds());
    }

    @Override
    public Result<CertificateInfoType> getCertificateInfoForAuthenticationCertificate(Credential credential) throws TechnicalConnectorException {
        GetCertificateInfoForAuthenticationCertificateRequest req = new GetCertificateInfoForAuthenticationCertificateRequest();
        RaUtils.setCommonAttributes((RequestType)req);
        String signedPayload = RaUtils.sign(req, req.getId(), credential);
        GetCertificateInfoForAuthenticationCertificateResponse response = RaUtils.invokeCertRa(signedPayload, "urn:be:fgov:ehealth:etee:certra:protocol:v2:getCertificateInfoForAuthenticationCertificate", GetCertificateInfoForAuthenticationCertificateResponse.class).getResult();
        return new Result<CertificateInfoType>(response.getCertificateInfo(), (StatusResponseType)response);
    }

    @Override
    public Result<List<CertificateInfoType>> getCertificateInfoForCitizen() throws TechnicalConnectorException {
        GetCertificateInfoForCitizenRequest req = new GetCertificateInfoForCitizenRequest();
        RaUtils.setCommonAttributes((RequestType)req);
        String signedPayload = RaUtils.sign(req, req.getId(), this.authCred);
        GetCertificateInfoForCitizenResponse response = RaUtils.invokeCertRa(signedPayload, "urn:be:fgov:ehealth:certra:protocol:v2:getCertificateInfoForCitizen", GetCertificateInfoForCitizenResponse.class).getResult();
        return new Result<List<CertificateInfoType>>(response.getCertificateInfos(), (StatusResponseType)response);
    }

    @Override
    public Result<SubmitCSRForForeignerResponseInfo> submitCSRForForeigner(ForeignerRequest foreignerRequest) throws TechnicalConnectorException {
        SubmitCSRForForeignerRequest req = MapperFactory.mapper().asSubmitCSRForForeignerRequest(foreignerRequest);
        RaUtils.setIssueInstant((RequestType)req);
        SubmitCSRForForeignerResponse response = RaUtils.invokeCertRa(ConnectorXmlUtils.toString((Object)req), "urn:be:fgov:ehealth:certra:protocol:v2:submitCSRForForeigner", SubmitCSRForForeignerResponse.class).getResult();
        return new Result<SubmitCSRForForeignerResponseInfo>(MapperFactory.mapper().asSubmitCSRForForeignerResponseInfo(response), (StatusResponseType)response);
    }

    @Override
    public Result<GeneratedRevocationContract> generateRevocationContract(RevocationContractRequest revocationContractRequest) throws TechnicalConnectorException {
        GenerateRevocationContractRequest req = MapperFactory.mapper().asGenerateContractRequest(revocationContractRequest);
        RaUtils.setIssueInstant((RequestType)req);
        GenerateRevocationContractResponse response = RaUtils.invokeCertRa(ConnectorXmlUtils.toString((Object)req), "urn:be:fgov:ehealth:certra:protocol:v2:generateRevocationContract", GenerateRevocationContractResponse.class).getResult();
        return new Result<GeneratedRevocationContract>(MapperFactory.mapper().asRevocationContract(response.getContract()), (StatusResponseType)response);
    }

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        this.authCred = BeIDCredential.getInstance((String)"CertRA", (String)"Authentication");
        this.signCred = BeIDCredential.getInstance((String)"CertRA", (String)"Signature");
    }
}

