/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.cert.CertPathChecker;
import be.fgov.ehealth.etee.crypto.decrypt.CMSMessageContext;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierAbstract;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierData;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierResult;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributes;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributesReceiver;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.policies.SignatureLayer;
import be.fgov.ehealth.etee.crypto.policies.SigningCredential;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.utils.DistinguishedName;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignedDataVerifierInner
extends SignedDataVerifierAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedDataVerifierInner.class);

    public SignedDataVerifierInner(Collection<SigningPolicy> signingPolicies, int[] requiredKeyUsage, OCSPChecker ocspChecker, CertPathChecker certPathChecker, SignerInfoAttributesReceiver signerInfoAttributesReceiver) {
        super(SignatureLayer.INNER, signingPolicies, requiredKeyUsage, ocspChecker, certPathChecker, signerInfoAttributesReceiver);
    }

    @Override
    public CryptoResult<SignedDataVerifierData> verifySignedData(CMSMessageContext<?> cmsMsgContext, SignedDataVerifierData outerVerificationData, SigningCredential ... signers) {
        SignedDataVerifierResult result = new SignedDataVerifierResult();
        SignerInformation signerInformation = cmsMsgContext.getSignerInformation();
        if (!cmsMsgContext.isStreamingMode()) {
            result.setContent(cmsMsgContext.getContentStream());
        }
        result.setSignerInformation(signerInformation);
        result.setSignature(signerInformation.getSignature());
        SignerInfoAttributes signerInfoAttributes = this.getSignerInfoAttributes(result, signerInformation);
        String subjectKeyIdentifier = this.getSubjectKeyIdentifier(cmsMsgContext);
        if (subjectKeyIdentifier != null) {
            result.setSignatureKeyIdentifier(subjectKeyIdentifier);
            LOGGER.info("Message Author: PublicKey [" + subjectKeyIdentifier + "]");
            this.verifyPublicKey(result, cmsMsgContext, subjectKeyIdentifier, signers);
            this.verifyMessageIntegrity(result, outerVerificationData.getSignerInformation().getSID(), signerInformation.getSID());
        } else {
            X509Certificate signerCertificate = cmsMsgContext.getAuthenticationCertificate();
            result.setSignatureCert(signerCertificate);
            if (signerCertificate == null) {
                LOGGER.info("Message Author: [no cert available]");
                if (outerVerificationData.getAuthenticationCert() != null) {
                    LOGGER.debug(this.buildMsg("Verify inner signature with outer certificate: " + outerVerificationData.getAuthenticationCert().getSubjectX500Principal()));
                    this.verifySignature(result, signerInformation, outerVerificationData.getAuthenticationCert());
                    this.verifySigningKeySpecs(result, signerInformation, outerVerificationData.getAuthenticationCert().getPublicKey());
                    this.verifyCertificateKeyUsage(result, outerVerificationData.getAuthenticationCert());
                    if (signers != null && signers.length > 0) {
                        this.verifySigner(result, outerVerificationData.getAuthenticationCert(), signers);
                    }
                }
                return result;
            }
            LOGGER.info("Author: X.509 Certificate [" + signerCertificate.getSerialNumber() + "]");
            if (signers != null && signers.length > 0) {
                this.verifySigner(result, signerCertificate, signers);
            }
            if (outerVerificationData.getAuthenticationCert() != null) {
                this.verifyMessageIntegrity(result, outerVerificationData.getAuthenticationCert(), signerCertificate);
            }
            this.verifyCertificate(result, cmsMsgContext, signerInfoAttributes, outerVerificationData.getSigningTime());
        }
        return result;
    }

    private void verifyMessageIntegrity(SignedDataVerifierResult result, X509Certificate outer, X509Certificate inner) {
        if (!this.checkCertificateCorrelation(outer, inner)) {
            result.getErrors().add(NotificationError.MESSAGE_INTEGRITY_INVALID);
        }
    }

    private void verifyMessageIntegrity(SignedDataVerifierResult result, SignerId outer, SignerId inner) {
        if (!this.checkSubjectKeyCorrelation(outer, inner)) {
            result.getErrors().add(NotificationError.MESSAGE_INTEGRITY_INVALID);
        }
    }

    private boolean checkSubjectKeyCorrelation(SignerId outer, SignerId inner) {
        return outer != null && inner != null && outer.getSubjectKeyIdentifier() != null && inner.getSubjectKeyIdentifier() != null && Arrays.equals(outer.getSubjectKeyIdentifier(), inner.getSubjectKeyIdentifier());
    }

    private boolean checkCertificateCorrelation(X509Certificate outer, X509Certificate inner) {
        LOGGER.debug("Verify correlation between inner and outer certificate.");
        DistinguishedName outerDN = DistinguishedName.from(outer.getSubjectX500Principal());
        DistinguishedName innerDN = DistinguishedName.from(inner.getSubjectX500Principal());
        if (!outerDN.hasSerialNumber() && !innerDN.hasSerialNumber()) {
            LOGGER.warn("Certificates have no serialnumber. Subject must be same.");
            return outer.getSubjectX500Principal().equals(inner.getSubjectX500Principal());
        }
        if (outerDN.hasSerialNumber() && outerDN.getSerialNumber().equals(innerDN.getSerialNumber())) {
            LOGGER.debug("Sender = Author [X.509 Certificate SerialNumber=" + outerDN.getSerialNumber() + "]");
            return true;
        }
        LOGGER.warn("SerialNumbers certificates do not match: " + outerDN.getSerialNumber() + " - " + innerDN.getSerialNumber());
        return false;
    }
}

