﻿﻿/*
 * Created by SharpDevelop.
 * User: EH058
 * Date: 11/06/2014
 * Time: 10:55
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using be.ehealth.technicalconnector.idgenerator;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using org.w3._2005._05.xmlmime;
using be.ehealth.business.mycarenetcommons.builders;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetdomaincommons.builders.impl;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.business.mycarenetdomaincommons.exception;
using be.ehealth.business.mycarenetdomaincommons.util;

using be.ehealth.businessconnector.registration.builder;
using be.ehealth.businessconnector.registration.session;
using be.ehealth.technicalconnector.config.util;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.mycarenet.registration.protocol.v1;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.registration.session
{
	/// <summary>
	/// Description of RegistrationIntegrationTest.
	/// </summary>
	[TestFixture]
	public class RegistrationIntegrationTest
	{

		[SetUp]
		public static void setupsession()  {
			SessionInitializer.init(".\\be.ehealth.businessconnector.registration.test.properties", SupportedLanguages.NET.getAbbreviation());
		}

		[TearDown]
		public static void teardownSession()  {
			Session.getInstance().unloadSession();
		}

		[Test]
		public void registerOA100Test(){
			testOa("100");
		}

		[Test]
		public void registerOA300Test(){
			testOa("300");
		}

		[Test]
		public void registerOA500Test(){
			testOa("500");
		}

		[Test]
		public void registerOA600Test(){
			testOa("600");
		}

		[Test]
		public void registerOA900Test(){
			testOa("900");
		}

		/**
		 * @param oa
		 */
		private void testOa(String oa){

			RegisterToMycarenetServiceResponse response = getResponse(oa);

			ResponseBuilder responseBuilder = ResponseBuilderFactory.getResponseBuilder("mcn.registration");

			String xmlValue = responseBuilder.getResponse(response);
			
			Assert.IsNotNull(xmlValue);
		}


		/**
		 * @param oa
		 * @return
		 * @throws TechnicalConnectorException
		 * @throws InvalidBlobContentConnectorException
		 * @throws ConnectorException
		 */
		private RegisterToMycarenetServiceResponse getResponse(String oa) {
			RequestBuilder mapper = RegistrationRequestBuilderFactory.getRequestObjectBuilder();
			CommonInput commonInput = RequestBuilderFactory.getCommonBuilder("mcn.registration").createCommonInput(McnConfigUtil.retrievePackageInfo("mcn.registration"), false, IdGeneratorFactory.getIdGenerator().generateId());

			InputStream businessXmlContentStream = ConnectorIOUtils.getResourceAsStream(".\\examples\\DetailContentOfExamplesRegistrationRequest.xml");
			String testFileContent = System.Text.Encoding.Default.GetString(ConnectorIOUtils.getBytes(businessXmlContentStream));
			testFileContent = testFileContent.replaceAll("replaceWithDateYYYY-MM-DD", new org.joda.time.DateTime().toString("YYYY-MM-dd"));
			testFileContent = testFileContent.replaceAll("replaceWithNihiiNumber", SessionUtil.getNihii11());
			
			Blob blob = BlobBuilderFactory.getBlobBuilder("mcn.registration").build(testFileContent.getBytes());
			RegisterToMycarenetServiceRequest request = mapper.buildRegisterToMycarenetRequest(commonInput, getRouting(oa), blob, null);
			RegistrationSession session = RegistrationSessionFactory.getRegistrationSession();

			RegisterToMycarenetServiceResponse response = session.registerToMycarenetService(request);
			return response;
		}


		private static Routing getRouting(String oa) {
			CareReceiverId careReceiver = new CareReceiverId(null);
			careReceiver.setMutuality(oa);
			return new Routing(careReceiver, new org.joda.time.DateTime());
		}
	}
}
