/*
 * Copyright (c) eHealth
 */
using System;
using System.IO;
using be.ehealth.businessconnector.genins.builders;
using be.ehealth.businessconnector.genins.domain;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.fgov.ehealth.genericinsurability.core.v1;
using be.fgov.ehealth.genericinsurability.protocol.v1;
using org.joda.time;
using NUnit.Framework;
using be.ehealth.technicalconnector.validator;
using be.ehealth.technicalconnector.validator.impl;
using be.ehealth.technicalconnector.utils;
using be.ehealth.businessconnector.genins.service;
using java.util;
using XmlUnit;

/**
 * 
 * GenInsSessionIntegrationTest class.
 * 
 * @author EHP
 * 
 */
namespace be.ehealth.businessconnector.genins.session
{
	[TestFixture]
	public class GenInsSessionIntegrationTest
	{
		private static Properties props;
		
		[SetUp]
		public static void init() {
			props = TestPropertiesLoader.getProperties(".\\be.ehealth.businessconnector.genins.test.properties",SupportedLanguages.NET.getAbbreviation());
			SessionInitializer.init(props, SupportedLanguages.NET.getAbbreviation());
		}
		
		[TearDown]
		public static void deinit(){
			Session.getInstance().unloadSession();
		}
		
	
		[Test]
		public void testOA500() {
			getInsurabilityTest("75042628553", "501", "1234", InsurabilityContactTypeType.AMBULATORY_CARE, InsurabilityRequestTypeType.INFORMATION);
		}
		
		
		private void getInsurabilityTest(String inss, String mutuality, String regnrWithMut, InsurabilityContactTypeType insurabilityContactTypeType, InsurabilityRequestTypeType insurabilityRequestTypeType) {

        RequestParameters requestParameters = new RequestParameters();
        requestParameters.setInss(inss);
        requestParameters.setMutuality(mutuality);
        requestParameters.setRegNrWithMut(regnrWithMut);
        org.joda.time.DateTime dateTime = new org.joda.time.DateTime();
        requestParameters.setPeriodStart(dateTime);
        requestParameters.setPeriodEnd(dateTime);
        requestParameters.setInsurabilityReference(IdGeneratorFactory.getIdGenerator().generateId());
        requestParameters.setInsurabilityContactType(insurabilityContactTypeType);
        requestParameters.setInsurabilityRequestType(insurabilityRequestTypeType);

        GetInsurabilityAsXmlOrFlatRequestType request = RequestObjectBuilderFactory.getRequestObjectBuilder().createGetInsurabilityRequest(requestParameters, true);

        GenInsService service = GenInsSessionServiceFactory.getGenInsService();

        GetInsurabilityResponse response = service.getInsurability(request);

        // Validate against XSD
        ValidatorHelper.validate(response, response.getClass(), ServiceFactory.GENINS_XSD[0]);
        // Verify EHealth STATUS
        new EhealthReplyValidatorImpl().validateReplyStatus(response);
        // Verify that request & response InsurabilityRequestDetail are equal.
        AssertExpectedResult(ConnectorXmlUtils.toString(request.getRequest().getInsurabilityRequestDetail()),ConnectorXmlUtils.toString(response.getResponse().getInsurabilityRequestDetail()),true);
        // Verify that the message doesn't contains a messagefault.
        MessageFaultType messageFault = response.getResponse().getMessageFault();
        ConnectorXmlUtils.dump(messageFault);
        Assert.Null(messageFault,"MessageFault <> null;");
		}

		private void AssertExpectedResult(string input1, string input2, bool expected) {
		   TextReader reader1 = new StringReader(ConnectorXmlUtils.flatten(input1));
		   TextReader reader2 = new StringReader(ConnectorXmlUtils.flatten(input2));
		   XmlDiff xmld = new XmlDiff(reader1,reader2);     
		   DiffResult result = xmld.Compare();
		   string msg = string.Format("comparing {0} to {1}: {2}", input1, input2, result.Difference);
		   Assert.AreEqual(expected, result.Equal, msg);
		}
	}
}
